/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategy;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategyConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class EntityOwnerSelectionStrategyConfigReader {
    public static final String CONFIG_ID = "org.opendaylight.controller.cluster.entity.owner.selection.strategies";
    private static final Logger LOG = LoggerFactory.getLogger(EntityOwnerSelectionStrategyConfigReader.class);
    private static final String ENTITY_TYPE_PREFIX = "entity.type.";

    private EntityOwnerSelectionStrategyConfigReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityOwnerSelectionStrategyConfig loadStrategyWithConfig(BundleContext bundleContext) {
        EntityOwnerSelectionStrategyConfig.Builder builder = EntityOwnerSelectionStrategyConfig.newBuilder();
        ServiceReference configAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        if (configAdminServiceReference == null) {
            LOG.warn("No ConfigurationAdmin service found");
            return builder.build();
        }
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)bundleContext.getService(configAdminServiceReference);
        if (configAdmin == null) {
            LOG.warn("Failed to get ConfigurationAdmin service");
            return builder.build();
        }
        try {
            Configuration config = configAdmin.getConfiguration(CONFIG_ID);
            if (config != null) {
                EntityOwnerSelectionStrategyConfig entityOwnerSelectionStrategyConfig = EntityOwnerSelectionStrategyConfigReader.parseConfiguration(builder, config);
                return entityOwnerSelectionStrategyConfig;
            }
            LOG.debug("Could not read strategy configuration file, will use default configuration");
        }
        catch (IOException e1) {
            LOG.warn("Failed to get configuration for {}, starting up empty", (Object)CONFIG_ID);
            EntityOwnerSelectionStrategyConfig entityOwnerSelectionStrategyConfig = builder.build();
            return entityOwnerSelectionStrategyConfig;
        }
        finally {
            try {
                bundleContext.ungetService(configAdminServiceReference);
            }
            catch (Exception e) {
                LOG.debug("Error from ungetService", (Throwable)e);
            }
        }
        return builder.build();
    }

    private static EntityOwnerSelectionStrategyConfig parseConfiguration(EntityOwnerSelectionStrategyConfig.Builder builder, Configuration config) {
        Dictionary properties = config.getProperties();
        if (properties == null) {
            LOG.debug("Empty strategy configuration {}, using defaults", (Object)config);
            return builder.build();
        }
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Class<? extends EntityOwnerSelectionStrategy> aClass;
            String key = (String)keys.nextElement();
            if (!key.startsWith(ENTITY_TYPE_PREFIX)) {
                LOG.debug("Ignoring non-conforming property key : {}");
                continue;
            }
            String[] strategyClassAndDelay = ((String)properties.get(key)).split(",");
            try {
                aClass = EntityOwnerSelectionStrategyConfigReader.loadClass(strategyClassAndDelay[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Failed to load class {}, ignoring it", (Object)strategyClassAndDelay[0], (Object)e);
                continue;
            }
            long delay = strategyClassAndDelay.length > 1 ? Long.parseLong(strategyClassAndDelay[1]) : 0L;
            String entityType = key.substring(key.lastIndexOf(".") + 1);
            builder.addStrategy(entityType, aClass, delay);
            LOG.debug("Entity Type '{}' using strategy {} delay {}", new Object[]{entityType, aClass, delay});
        }
        return builder.build();
    }

    @Deprecated
    private static Class<? extends EntityOwnerSelectionStrategy> loadClass(String strategyClassAndDelay) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = EntityOwnerSelectionStrategyConfigReader.class.getClassLoader().loadClass(strategyClassAndDelay);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to load strategy " + strategyClassAndDelay);
        }
        Preconditions.checkArgument((boolean)EntityOwnerSelectionStrategy.class.isAssignableFrom(clazz), (Object)"Selected implementation %s must implement EntityOwnerSelectionStrategy, clazz");
        return clazz;
    }
}

