/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;

public abstract class AbstractThreePhaseCommitMessage
extends VersionedExternalizableMessage {
    private static final long serialVersionUID = 1L;
    private TransactionIdentifier transactionId;

    protected AbstractThreePhaseCommitMessage() {
    }

    protected AbstractThreePhaseCommitMessage(TransactionIdentifier transactionId, short version) {
        super(version);
        this.transactionId = (TransactionIdentifier)Preconditions.checkNotNull((Object)transactionId);
    }

    public TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.transactionId = TransactionIdentifier.readFrom((DataInput)in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.transactionId.writeTo((DataOutput)out);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [transactionId=" + this.transactionId + ", version=" + this.getVersion() + "]";
    }
}

