/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.dom.store.impl.DOMImmutableDataChangeEvent;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DataChanged
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> change;

    public DataChanged() {
    }

    public DataChanged(AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> change) {
        this.change = change;
    }

    public AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> getChange() {
        return this.change;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        NormalizedNode node;
        YangInstanceIdentifier path;
        int i;
        in.readShort();
        NormalizedNodeDataInput streamReader = NormalizedNodeInputOutput.newDataInputWithoutValidation((DataInput)in);
        DOMImmutableDataChangeEvent.Builder builder = DOMImmutableDataChangeEvent.builder((AsyncDataBroker.DataChangeScope)AsyncDataBroker.DataChangeScope.SUBTREE);
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            path = streamReader.readYangInstanceIdentifier();
            node = streamReader.readNormalizedNode();
            builder.addCreated(path, node);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            path = streamReader.readYangInstanceIdentifier();
            NormalizedNode before = streamReader.readNormalizedNode();
            NormalizedNode after = streamReader.readNormalizedNode();
            builder.addUpdated(path, before, after);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            path = streamReader.readYangInstanceIdentifier();
            node = streamReader.readNormalizedNode();
            builder.addRemoved(path, node);
        }
        boolean present = in.readBoolean();
        if (present) {
            builder.setBefore(streamReader.readNormalizedNode());
        }
        if (present = in.readBoolean()) {
            builder.setAfter(streamReader.readNormalizedNode());
        }
        this.change = builder.build();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        NormalizedNode updatedSubtree;
        out.writeShort(5);
        NormalizedNodeDataOutput streamWriter = NormalizedNodeInputOutput.newDataOutput((DataOutput)out);
        Map createdData = this.change.getCreatedData();
        out.writeInt(createdData.size());
        for (Map.Entry e : createdData.entrySet()) {
            streamWriter.writeYangInstanceIdentifier((YangInstanceIdentifier)e.getKey());
            streamWriter.writeNormalizedNode((NormalizedNode)e.getValue());
        }
        Map originalData = this.change.getOriginalData();
        Map updatedData = this.change.getUpdatedData();
        out.writeInt(updatedData.size());
        for (Map.Entry entry : updatedData.entrySet()) {
            streamWriter.writeYangInstanceIdentifier((YangInstanceIdentifier)entry.getKey());
            streamWriter.writeNormalizedNode((NormalizedNode)originalData.get(entry.getKey()));
            streamWriter.writeNormalizedNode((NormalizedNode)entry.getValue());
        }
        Set removed = this.change.getRemovedPaths();
        out.writeInt(removed.size());
        for (YangInstanceIdentifier path : removed) {
            streamWriter.writeYangInstanceIdentifier(path);
            streamWriter.writeNormalizedNode((NormalizedNode)originalData.get(path));
        }
        NormalizedNode normalizedNode = (NormalizedNode)this.change.getOriginalSubtree();
        out.writeBoolean(normalizedNode != null);
        if (normalizedNode != null) {
            streamWriter.writeNormalizedNode(normalizedNode);
        }
        out.writeBoolean((updatedSubtree = (NormalizedNode)this.change.getUpdatedSubtree()) != null);
        if (updatedSubtree != null) {
            streamWriter.writeNormalizedNode(updatedSubtree);
        }
    }
}

