/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;

public class PrimaryShardInfo {
    private final ActorSelection primaryShardActor;
    private final short primaryShardVersion;
    private final DataTree localShardDataTree;

    public PrimaryShardInfo(@Nonnull ActorSelection primaryShardActor, short primaryShardVersion, @Nonnull DataTree localShardDataTree) {
        this.primaryShardActor = (ActorSelection)Preconditions.checkNotNull((Object)primaryShardActor);
        this.primaryShardVersion = primaryShardVersion;
        this.localShardDataTree = (DataTree)Preconditions.checkNotNull((Object)localShardDataTree);
    }

    public PrimaryShardInfo(@Nonnull ActorSelection primaryShardActor, short primaryShardVersion) {
        this.primaryShardActor = (ActorSelection)Preconditions.checkNotNull((Object)primaryShardActor);
        this.primaryShardVersion = primaryShardVersion;
        this.localShardDataTree = null;
    }

    @Nonnull
    public ActorSelection getPrimaryShardActor() {
        return this.primaryShardActor;
    }

    public short getPrimaryShardVersion() {
        return this.primaryShardVersion;
    }

    @Nonnull
    public Optional<DataTree> getLocalShardDataTree() {
        return Optional.ofNullable(this.localShardDataTree);
    }
}

