/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import akka.serialization.JSerializer;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.utils.AbstractBatchedModificationsCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;

public final class ReadyLocalTransactionSerializer
extends JSerializer {
    public int identifier() {
        return 97439437;
    }

    public boolean includeManifest() {
        return false;
    }

    public byte[] toBinary(Object obj) {
        Preconditions.checkArgument((boolean)(obj instanceof ReadyLocalTransaction), (String)"Unsupported object type %s", obj.getClass());
        ReadyLocalTransaction readyLocal = (ReadyLocalTransaction)obj;
        BatchedModifications batched = new BatchedModifications(readyLocal.getTransactionId(), readyLocal.getRemoteVersion());
        batched.setDoCommitOnReady(readyLocal.isDoCommitOnReady());
        batched.setTotalMessagesSent(1);
        batched.setReady(true);
        readyLocal.getModification().applyToCursor((DataTreeModificationCursor)new BatchedCursor(batched));
        return SerializationUtils.serialize((Serializable)batched);
    }

    public Object fromBinaryJava(byte[] bytes, Class<?> clazz) {
        return SerializationUtils.deserialize((byte[])bytes);
    }

    private static final class BatchedCursor
    extends AbstractBatchedModificationsCursor {
        private final BatchedModifications message;

        BatchedCursor(BatchedModifications message) {
            this.message = (BatchedModifications)Preconditions.checkNotNull((Object)message);
        }

        @Override
        protected BatchedModifications getModifications() {
            return this.message;
        }
    }
}

