/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import akka.actor.ActorPath;
import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.messages.ListenerRegistrationMessage;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class RegisterDataTreeChangeListener
implements Externalizable,
ListenerRegistrationMessage {
    private static final long serialVersionUID = 1L;
    private ActorRef dataTreeChangeListenerPath;
    private YangInstanceIdentifier path;
    private boolean registerOnAllInstances;

    public RegisterDataTreeChangeListener() {
    }

    public RegisterDataTreeChangeListener(YangInstanceIdentifier path, ActorRef dataTreeChangeListenerPath, boolean registerOnAllInstances) {
        this.path = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)path);
        this.dataTreeChangeListenerPath = (ActorRef)Preconditions.checkNotNull((Object)dataTreeChangeListenerPath);
        this.registerOnAllInstances = registerOnAllInstances;
    }

    @Override
    public YangInstanceIdentifier getPath() {
        return this.path;
    }

    @Override
    public ActorPath getListenerActorPath() {
        return this.dataTreeChangeListenerPath.path();
    }

    @Override
    public boolean isRegisterOnAllInstances() {
        return this.registerOnAllInstances;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dataTreeChangeListenerPath);
        SerializationUtils.serializePath((YangInstanceIdentifier)this.path, (DataOutput)out);
        out.writeBoolean(this.registerOnAllInstances);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataTreeChangeListenerPath = (ActorRef)in.readObject();
        this.path = SerializationUtils.deserializePath((DataInput)in);
        this.registerOnAllInstances = in.readBoolean();
    }

    public String toString() {
        return "RegisterDataTreeChangeListener [path=" + this.path + ", registerOnAllInstances=" + this.registerOnAllInstances + ", dataTreeChangeListenerPath=" + this.dataTreeChangeListenerPath + "]";
    }
}

