/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;
import org.opendaylight.controller.cluster.datastore.modification.CompositeModification;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

public class MutableCompositeModification
extends VersionedExternalizableMessage
implements CompositeModification {
    private static final long serialVersionUID = 1L;
    private final List<Modification> modifications = new ArrayList<Modification>();
    private List<Modification> immutableModifications = null;

    public MutableCompositeModification() {
        this(5);
    }

    public MutableCompositeModification(short version) {
        super(version);
    }

    @Override
    public void apply(DOMStoreWriteTransaction transaction) {
        for (Modification modification : this.modifications) {
            modification.apply(transaction);
        }
    }

    @Override
    public void apply(DataTreeModification transaction) {
        for (Modification modification : this.modifications) {
            modification.apply(transaction);
        }
    }

    @Override
    public byte getType() {
        return 1;
    }

    public void addModification(Modification modification) {
        Preconditions.checkNotNull((Object)modification);
        this.modifications.add(modification);
    }

    public void addModifications(Iterable<Modification> newMods) {
        for (Modification mod : newMods) {
            this.addModification(mod);
        }
    }

    @Override
    public List<Modification> getModifications() {
        if (this.immutableModifications == null) {
            this.immutableModifications = Collections.unmodifiableList(this.modifications);
        }
        return this.immutableModifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        if (size > 1) {
            SerializationUtils.REUSABLE_READER_TL.set(NormalizedNodeInputOutput.newDataInputWithoutValidation((DataInput)in));
        }
        try {
            block8: for (int i = 0; i < size; ++i) {
                byte type = in.readByte();
                switch (type) {
                    case 2: {
                        this.modifications.add(WriteModification.fromStream(in, this.getVersion()));
                        continue block8;
                    }
                    case 3: {
                        this.modifications.add(MergeModification.fromStream(in, this.getVersion()));
                        continue block8;
                    }
                    case 4: {
                        this.modifications.add(DeleteModification.fromStream(in, this.getVersion()));
                        continue block8;
                    }
                }
            }
        }
        finally {
            SerializationUtils.REUSABLE_READER_TL.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.modifications.size());
        if (this.modifications.size() > 1) {
            SerializationUtils.REUSABLE_WRITER_TL.set(NormalizedNodeInputOutput.newDataOutput((DataOutput)out));
        }
        try {
            for (Modification mod : this.modifications) {
                out.writeByte(mod.getType());
                mod.writeExternal(out);
            }
        }
        finally {
            SerializationUtils.REUSABLE_WRITER_TL.remove();
        }
    }

    public static MutableCompositeModification fromSerializable(Object serializable) {
        Preconditions.checkArgument((boolean)(serializable instanceof MutableCompositeModification));
        return (MutableCompositeModification)serializable;
    }
}

