/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;

abstract class ModifiedDataTreeCandidateNode
extends AbstractDataTreeCandidateNode {
    private final Collection<DataTreeCandidateNode> children;

    private ModifiedDataTreeCandidateNode(ModificationType type, Collection<DataTreeCandidateNode> children) {
        super(type);
        this.children = (Collection)Preconditions.checkNotNull(children);
    }

    static DataTreeCandidateNode create(ModificationType type, Collection<DataTreeCandidateNode> children) {
        return new ModifiedDataTreeCandidateNode(type, (Collection)children){

            public YangInstanceIdentifier.PathArgument getIdentifier() {
                throw new UnsupportedOperationException("Root node does not have an identifier");
            }
        };
    }

    static DataTreeCandidateNode create(final YangInstanceIdentifier.PathArgument identifier, ModificationType type, Collection<DataTreeCandidateNode> children) {
        return new ModifiedDataTreeCandidateNode(type, children){

            public YangInstanceIdentifier.PathArgument getIdentifier() {
                return identifier;
            }
        };
    }

    public final Optional<NormalizedNode<?, ?>> getDataAfter() {
        throw new UnsupportedOperationException("After-image not available after serialization");
    }

    public final Collection<DataTreeCandidateNode> getChildNodes() {
        return this.children;
    }
}

