/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.datastore.persisted.FutureVersionException;
import org.opendaylight.controller.cluster.datastore.persisted.PastVersionException;
import org.opendaylight.yangtools.concepts.WritableObject;

@Beta
public enum PayloadVersion implements WritableObject
{
    TEST_PAST_VERSION(0),
    BORON(5),
    TEST_FUTURE_VERSION(65535);

    private final short value;

    private PayloadVersion(int intVersion) {
        Preconditions.checkArgument((intVersion >= 0 && intVersion <= 65535 ? 1 : 0) != 0);
        this.value = (short)intVersion;
    }

    public short shortValue() {
        return this.value;
    }

    @Nonnull
    public static PayloadVersion current() {
        return BORON;
    }

    @Nonnull
    public static PayloadVersion valueOf(short version) throws FutureVersionException, PastVersionException {
        switch (Short.toUnsignedInt(version)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new PastVersionException(version, BORON);
            }
            case 5: {
                return BORON;
            }
        }
        throw new FutureVersionException(version, BORON);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    @Nonnull
    public static PayloadVersion readFrom(@Nonnull DataInput in) throws IOException {
        short s = in.readShort();
        try {
            return PayloadVersion.valueOf(s);
        }
        catch (FutureVersionException | PastVersionException e) {
            throw new IOException("Unsupported version", e);
        }
    }
}

