/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.datastore.config.PrefixShardConfiguration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;

public class ShardManagerSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> shardList;
    private final Map<DOMDataTreeIdentifier, PrefixShardConfiguration> prefixShardConfiguration;

    public ShardManagerSnapshot(@Nonnull List<String> shardList, Map<DOMDataTreeIdentifier, PrefixShardConfiguration> prefixShardConfiguration) {
        this.shardList = ImmutableList.copyOf(shardList);
        this.prefixShardConfiguration = ImmutableMap.copyOf(prefixShardConfiguration);
    }

    public List<String> getShardList() {
        return this.shardList;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public String toString() {
        return "ShardManagerSnapshot [ShardList = " + this.shardList + " ]";
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShardManagerSnapshot snapshot;

        public Proxy() {
        }

        Proxy(ShardManagerSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.snapshot.shardList.size());
            for (String string : this.snapshot.shardList) {
                out.writeObject(string);
            }
            out.writeInt(this.snapshot.prefixShardConfiguration.size());
            for (Map.Entry entry : this.snapshot.prefixShardConfiguration.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ArrayList<String> shardList = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                shardList.add((String)in.readObject());
            }
            size = in.readInt();
            HashMap<DOMDataTreeIdentifier, PrefixShardConfiguration> prefixShardConfiguration = new HashMap<DOMDataTreeIdentifier, PrefixShardConfiguration>(size);
            for (int i = 0; i < size; ++i) {
                prefixShardConfiguration.put((DOMDataTreeIdentifier)in.readObject(), (PrefixShardConfiguration)in.readObject());
            }
            this.snapshot = new ShardManagerSnapshot(shardList, prefixShardConfiguration);
        }

        private Object readResolve() {
            return this.snapshot;
        }
    }
}

