/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.Address;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardManagerIdentifier;
import org.opendaylight.controller.cluster.raft.PeerAddressResolver;

class ShardPeerAddressResolver
implements PeerAddressResolver {
    private final ConcurrentMap<MemberName, Address> memberNameToAddress = new ConcurrentHashMap<MemberName, Address>();
    private final String shardManagerIdentifier;
    private final String shardManagerType;
    private final MemberName localMemberName;

    ShardPeerAddressResolver(String shardManagerType, MemberName localMemberName) {
        this.shardManagerIdentifier = ShardManagerIdentifier.builder().type(shardManagerType).build().toString();
        this.shardManagerType = shardManagerType;
        this.localMemberName = (MemberName)Preconditions.checkNotNull((Object)localMemberName);
    }

    void addPeerAddress(MemberName memberName, Address address) {
        this.memberNameToAddress.put(memberName, address);
    }

    void removePeerAddress(MemberName memberName) {
        this.memberNameToAddress.remove(memberName);
    }

    Address getPeerAddress(MemberName memberName) {
        return (Address)this.memberNameToAddress.get(memberName);
    }

    Collection<String> getShardManagerPeerActorAddresses() {
        ArrayList<String> peerAddresses = new ArrayList<String>();
        for (Map.Entry entry : this.memberNameToAddress.entrySet()) {
            if (this.localMemberName.equals(entry.getKey())) continue;
            peerAddresses.add(this.getShardManagerActorPathBuilder((Address)entry.getValue()).toString());
        }
        return peerAddresses;
    }

    ShardIdentifier getShardIdentifier(MemberName memberName, String shardName) {
        return ShardIdentifier.create(shardName, memberName, this.shardManagerType);
    }

    String getShardActorAddress(String shardName, MemberName memberName) {
        Address memberAddress = (Address)this.memberNameToAddress.get(memberName);
        if (memberAddress != null) {
            return this.getShardManagerActorPathBuilder(memberAddress).append("/").append(this.getShardIdentifier(memberName, shardName)).toString();
        }
        return null;
    }

    StringBuilder getShardManagerActorPathBuilder(Address address) {
        return new StringBuilder().append(address.toString()).append("/user/").append(this.shardManagerIdentifier);
    }

    public String resolve(String peerId) {
        if (peerId == null) {
            return null;
        }
        ShardIdentifier shardId = ShardIdentifier.fromShardIdString(peerId);
        return this.getShardActorAddress(shardId.getShardName(), shardId.getMemberName());
    }
}

