/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.raft.RaftState;

final class SwitchShardBehavior {
    private final ShardIdentifier shardId;
    private final RaftState newState;
    private final long term;

    SwitchShardBehavior(ShardIdentifier shardId, RaftState newState, long term) {
        this.newState = (RaftState)Preconditions.checkNotNull((Object)newState);
        this.shardId = shardId;
        this.term = term;
    }

    @Nullable
    ShardIdentifier getShardId() {
        return this.shardId;
    }

    RaftState getNewState() {
        return this.newState;
    }

    long getTerm() {
        return this.term;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SwitchShardBehavior{");
        sb.append("shardId='").append(this.shardId).append('\'');
        sb.append(", newState='").append(this.newState).append('\'');
        sb.append(", term=").append(this.term);
        sb.append('}');
        return sb.toString();
    }
}

