/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterUtils.class);
    public static final String PREFIX_CONFIG_SHARD_ID = "prefix-configuration-shard";
    public static final QName PREFIX_SHARDS_QNAME = QName.create((String)"urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:prefix-shard-configuration", (String)"2017-01-10", (String)"prefix-shards").intern();
    public static final QName SHARD_LIST_QNAME = QName.create((QName)PREFIX_SHARDS_QNAME, (String)"shard").intern();
    public static final QName SHARD_PREFIX_QNAME = QName.create((QName)PREFIX_SHARDS_QNAME, (String)"prefix").intern();
    public static final QName SHARD_REPLICAS_QNAME = QName.create((QName)PREFIX_SHARDS_QNAME, (String)"replicas").intern();
    public static final QName SHARD_REPLICA_QNAME = QName.create((QName)PREFIX_SHARDS_QNAME, (String)"replica").intern();
    public static final YangInstanceIdentifier PREFIX_SHARDS_PATH = YangInstanceIdentifier.of((QName)PREFIX_SHARDS_QNAME).toOptimized();
    public static final YangInstanceIdentifier SHARD_LIST_PATH = PREFIX_SHARDS_PATH.node(SHARD_LIST_QNAME).toOptimized();

    public static ShardIdentifier getShardIdentifier(MemberName memberName, DOMDataTreeIdentifier prefix) {
        String type;
        switch (prefix.getDatastoreType()) {
            case OPERATIONAL: {
                type = "operational";
                break;
            }
            case CONFIGURATION: {
                type = "config";
                break;
            }
            default: {
                type = prefix.getDatastoreType().name();
                LOG.warn("Unknown data store type {}", (Object)type);
            }
        }
        return ShardIdentifier.create(ClusterUtils.getCleanShardName(prefix.getRootIdentifier()), memberName, type);
    }

    public static String getCleanShardName(YangInstanceIdentifier path) {
        if (path.isEmpty()) {
            return "default";
        }
        StringBuilder builder = new StringBuilder();
        path.getPathArguments().forEach(p -> {
            builder.append(p.getNodeType().getLocalName());
            if (p instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                builder.append("-key_");
                ((YangInstanceIdentifier.NodeIdentifierWithPredicates)p).getKeyValues().forEach((key, value) -> {
                    builder.append(key.getLocalName());
                    builder.append(value);
                    builder.append("-");
                });
                builder.append("_");
            }
            builder.append("!");
        });
        return builder.toString();
    }
}

