/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.base.Optional;
import java.util.List;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class NormalizedNodeAggregator {
    private final YangInstanceIdentifier rootIdentifier;
    private final List<Optional<NormalizedNode<?, ?>>> nodes;
    private final DataTree dataTree;

    private NormalizedNodeAggregator(YangInstanceIdentifier rootIdentifier, List<Optional<NormalizedNode<?, ?>>> nodes, SchemaContext schemaContext, LogicalDatastoreType logicalDatastoreType) {
        this.rootIdentifier = rootIdentifier;
        this.nodes = nodes;
        this.dataTree = InMemoryDataTreeFactory.getInstance().create(logicalDatastoreType == LogicalDatastoreType.CONFIGURATION ? TreeType.CONFIGURATION : TreeType.OPERATIONAL);
        this.dataTree.setSchemaContext(schemaContext);
    }

    public static Optional<NormalizedNode<?, ?>> aggregate(YangInstanceIdentifier rootIdentifier, List<Optional<NormalizedNode<?, ?>>> nodes, SchemaContext schemaContext, LogicalDatastoreType logicalDatastoreType) throws DataValidationFailedException {
        return new NormalizedNodeAggregator(rootIdentifier, nodes, schemaContext, logicalDatastoreType).aggregate();
    }

    private Optional<NormalizedNode<?, ?>> aggregate() throws DataValidationFailedException {
        return this.combine().getRootNode();
    }

    private NormalizedNodeAggregator combine() throws DataValidationFailedException {
        DataTreeModification mod = this.dataTree.takeSnapshot().newModification();
        for (Optional<NormalizedNode<?, ?>> node : this.nodes) {
            if (!node.isPresent()) continue;
            mod.merge(this.rootIdentifier, (NormalizedNode)node.get());
        }
        mod.ready();
        this.dataTree.validate(mod);
        DataTreeCandidate candidate = this.dataTree.prepare(mod);
        this.dataTree.commit(candidate);
        return this;
    }

    private Optional<NormalizedNode<?, ?>> getRootNode() {
        return this.dataTree.takeSnapshot().readNode(this.rootIdentifier);
    }
}

