/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import java.io.IOException;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.NormalizedNodePruner;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PruningDataTreeModification
extends ForwardingObject
implements DataTreeModification {
    private static final Logger LOG = LoggerFactory.getLogger(PruningDataTreeModification.class);
    private DataTreeModification delegate;
    private final SchemaContext schemaContext;
    private final DataTree dataTree;

    public PruningDataTreeModification(DataTreeModification delegate, DataTree dataTree, SchemaContext schemaContext) {
        this.delegate = (DataTreeModification)Preconditions.checkNotNull((Object)delegate);
        this.dataTree = (DataTree)Preconditions.checkNotNull((Object)dataTree);
        this.schemaContext = (SchemaContext)Preconditions.checkNotNull((Object)schemaContext);
    }

    public DataTreeModification delegate() {
        return this.delegate;
    }

    public void delete(YangInstanceIdentifier yangInstanceIdentifier) {
        try {
            this.delegate.delete(yangInstanceIdentifier);
        }
        catch (SchemaValidationFailedException e) {
            LOG.warn("Node at path : {} does not exist ignoring delete", (Object)yangInstanceIdentifier);
        }
    }

    public void merge(YangInstanceIdentifier yangInstanceIdentifier, NormalizedNode<?, ?> normalizedNode) {
        try {
            if (YangInstanceIdentifier.EMPTY.equals((Object)yangInstanceIdentifier)) {
                this.pruneAndMergeNode(yangInstanceIdentifier, normalizedNode);
            } else {
                this.delegate.merge(yangInstanceIdentifier, normalizedNode);
            }
        }
        catch (SchemaValidationFailedException e) {
            LOG.warn("Node at path {} was pruned during merge due to validation error: {}", (Object)yangInstanceIdentifier, (Object)e.getMessage());
            this.pruneAndMergeNode(yangInstanceIdentifier, normalizedNode);
        }
    }

    private void pruneAndMergeNode(YangInstanceIdentifier yangInstanceIdentifier, NormalizedNode<?, ?> normalizedNode) {
        NormalizedNode<?, ?> pruned = this.pruneNormalizedNode(yangInstanceIdentifier, normalizedNode);
        if (pruned != null) {
            this.delegate.merge(yangInstanceIdentifier, pruned);
        }
    }

    public void write(YangInstanceIdentifier yangInstanceIdentifier, NormalizedNode<?, ?> normalizedNode) {
        try {
            if (YangInstanceIdentifier.EMPTY.equals((Object)yangInstanceIdentifier)) {
                this.pruneAndWriteNode(yangInstanceIdentifier, normalizedNode);
            } else {
                this.delegate.write(yangInstanceIdentifier, normalizedNode);
            }
        }
        catch (SchemaValidationFailedException e) {
            LOG.warn("Node at path : {} was pruned during write due to validation error: {}", (Object)yangInstanceIdentifier, (Object)e.getMessage());
            this.pruneAndWriteNode(yangInstanceIdentifier, normalizedNode);
        }
    }

    private void pruneAndWriteNode(YangInstanceIdentifier yangInstanceIdentifier, NormalizedNode<?, ?> normalizedNode) {
        NormalizedNode<?, ?> pruned = this.pruneNormalizedNode(yangInstanceIdentifier, normalizedNode);
        if (pruned != null) {
            this.delegate.write(yangInstanceIdentifier, pruned);
        }
    }

    public void ready() {
        try {
            this.delegate.ready();
        }
        catch (SchemaValidationFailedException e) {
            DataTreeModification newModification = this.dataTree.takeSnapshot().newModification();
            this.delegate.applyToCursor((DataTreeModificationCursor)new PruningDataTreeModificationCursor(newModification, this));
            this.delegate = newModification;
            this.delegate.ready();
        }
    }

    public void applyToCursor(DataTreeModificationCursor dataTreeModificationCursor) {
        this.delegate.applyToCursor(dataTreeModificationCursor);
    }

    public Optional<NormalizedNode<?, ?>> readNode(YangInstanceIdentifier yangInstanceIdentifier) {
        return this.delegate.readNode(yangInstanceIdentifier);
    }

    public DataTreeModification newModification() {
        return new PruningDataTreeModification(this.delegate.newModification(), this.dataTree, this.schemaContext);
    }

    @VisibleForTesting
    NormalizedNode<?, ?> pruneNormalizedNode(YangInstanceIdentifier path, NormalizedNode<?, ?> input) {
        NormalizedNodePruner pruner = new NormalizedNodePruner(path, this.schemaContext);
        try {
            NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)pruner).write(input);
        }
        catch (IOException ioe) {
            LOG.error("Unexpected IOException when pruning normalizedNode", (Throwable)ioe);
        }
        return pruner.normalizedNode();
    }

    private static class PruningDataTreeModificationCursor
    extends AbstractDataTreeModificationCursor {
        private final DataTreeModification toModification;
        private final PruningDataTreeModification pruningModification;

        PruningDataTreeModificationCursor(DataTreeModification toModification, PruningDataTreeModification pruningModification) {
            this.toModification = toModification;
            this.pruningModification = pruningModification;
        }

        public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
            YangInstanceIdentifier path = this.current().node(child);
            NormalizedNode<?, ?> prunedNode = this.pruningModification.pruneNormalizedNode(path, data);
            if (prunedNode != null) {
                this.toModification.write(path, prunedNode);
            }
        }

        public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
            YangInstanceIdentifier path = this.current().node(child);
            NormalizedNode<?, ?> prunedNode = this.pruningModification.pruneNormalizedNode(path, data);
            if (prunedNode != null) {
                this.toModification.merge(path, prunedNode);
            }
        }

        public void delete(YangInstanceIdentifier.PathArgument child) {
            try {
                this.toModification.delete(this.current().node(child));
            }
            catch (SchemaValidationFailedException schemaValidationFailedException) {
                // empty catch block
            }
        }
    }
}

