/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.AbstractRegistrationTree;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeNode;
import org.opendaylight.mdsal.dom.spi.shard.ChildShardContext;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaValidationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedShardChangePublisher
extends AbstractRegistrationTree<AbstractDOMDataTreeChangeListenerRegistration<?>>
implements DOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedShardChangePublisher.class);
    private final AbstractDataStore distributedDataStore;
    private final YangInstanceIdentifier shardPath;
    private final DataStoreClient client;
    private final Map<DOMDataTreeIdentifier, ChildShardContext> childShards;
    @GuardedBy(value="this")
    private final DataTree dataTree;

    public DistributedShardChangePublisher(DataStoreClient client, AbstractDataStore distributedDataStore, DOMDataTreeIdentifier prefix, Map<DOMDataTreeIdentifier, ChildShardContext> childShards) {
        this.client = client;
        this.distributedDataStore = distributedDataStore;
        this.dataTree = InMemoryDataTreeFactory.getInstance().create(TreeType.valueOf((String)prefix.getDatastoreType().name()), prefix.getRootIdentifier());
        this.dataTree.setSchemaContext(distributedDataStore.getActorContext().getSchemaContext());
        this.shardPath = prefix.getRootIdentifier();
        this.childShards = childShards;
    }

    protected void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Closing registration {}", registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier path, L listener) {
        this.takeLock();
        try {
            AbstractDOMDataTreeChangeListenerRegistration<L> abstractDOMDataTreeChangeListenerRegistration = this.setupListenerContext(path, listener);
            return abstractDOMDataTreeChangeListenerRegistration;
        }
        finally {
            this.releaseLock();
        }
    }

    private <L extends org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> setupListenerContext(YangInstanceIdentifier listenerPath, L listener) {
        YangInstanceIdentifier strippedIdentifier = listenerPath;
        if (!this.shardPath.isEmpty()) {
            strippedIdentifier = YangInstanceIdentifier.create(DistributedShardChangePublisher.stripShardPath(this.shardPath, listenerPath));
        }
        DOMDataTreeListenerWithSubshards subshardListener = new DOMDataTreeListenerWithSubshards(strippedIdentifier, listener);
        AbstractDOMDataTreeChangeListenerRegistration<L> reg = this.setupContextWithoutSubshards(listenerPath, strippedIdentifier, subshardListener);
        for (ChildShardContext maybeAffected : this.childShards.values()) {
            if (listenerPath.contains(maybeAffected.getPrefix().getRootIdentifier())) {
                LOG.debug("Adding new subshard{{}} to listener at {}", (Object)maybeAffected.getPrefix(), (Object)listenerPath);
                subshardListener.addSubshard(maybeAffected);
                continue;
            }
            if (!maybeAffected.getPrefix().getRootIdentifier().contains(listenerPath)) continue;
            throw new UnsupportedOperationException("Listener should be registered directly into initialDataChangeEvent subshard");
        }
        return reg;
    }

    private <L extends org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> setupContextWithoutSubshards(YangInstanceIdentifier shardLookup, YangInstanceIdentifier listenerPath, final DOMDataTreeListenerWithSubshards listener) {
        LOG.debug("Registering root listener full path: {}, path inside shard: {}", (Object)shardLookup, (Object)listenerPath);
        final RegistrationTreeNode node = this.findNodeFor(listenerPath.getPathArguments());
        final ProxyRegistration proxyReg = new ProxyRegistration(this.distributedDataStore.registerProxyListener(shardLookup, listenerPath, listener), listener);
        AbstractDOMDataTreeChangeListenerRegistration registration = new AbstractDOMDataTreeChangeListenerRegistration<L>(listener){

            protected void removeRegistration() {
                listener.close();
                DistributedShardChangePublisher.this.removeRegistration(node, (Object)this);
                DistributedShardChangePublisher.this.registrationRemoved(this);
                proxyReg.close();
            }
        };
        this.addRegistration(node, registration);
        return registration;
    }

    private static Iterable<YangInstanceIdentifier.PathArgument> stripShardPath(YangInstanceIdentifier shardPath, YangInstanceIdentifier listenerPath) {
        if (shardPath.isEmpty()) {
            return listenerPath.getPathArguments();
        }
        ArrayList<YangInstanceIdentifier.PathArgument> listenerPathArgs = new ArrayList<YangInstanceIdentifier.PathArgument>(listenerPath.getPathArguments());
        Iterator shardIter = shardPath.getPathArguments().iterator();
        Iterator listenerIter = listenerPathArgs.iterator();
        while (shardIter.hasNext() && ((YangInstanceIdentifier.PathArgument)shardIter.next()).equals(listenerIter.next())) {
            listenerIter.remove();
        }
        return listenerPathArgs;
    }

    synchronized DataTreeCandidate applyChanges(YangInstanceIdentifier listenerPath, Collection<DataTreeCandidate> changes) throws DataValidationFailedException {
        DataTreeModification modification = this.dataTree.takeSnapshot().newModification();
        for (DataTreeCandidate change : changes) {
            try {
                DataTreeCandidates.applyToModification((DataTreeModification)modification, (DataTreeCandidate)change);
            }
            catch (SchemaValidationFailedException e) {
                LOG.error("Validation failed {}", (Throwable)e);
            }
        }
        modification.ready();
        this.dataTree.validate(modification);
        DataTreeCandidate candidate = this.dataTree.prepare(modification);
        this.dataTree.commit(candidate);
        DataTreeCandidateNode modifiedChild = candidate.getRootNode();
        for (YangInstanceIdentifier.PathArgument pathArgument : listenerPath.getPathArguments()) {
            modifiedChild = modifiedChild.getModifiedChild(pathArgument);
        }
        if (modifiedChild == null) {
            modifiedChild = new EmptyDataTreeCandidateNode(this.dataTree.getRootPath().getLastPathArgument());
        }
        return DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)this.dataTree.getRootPath(), (DataTreeCandidateNode)modifiedChild);
    }

    private static final class EmptyDataTreeCandidateNode
    implements DataTreeCandidateNode {
        private final YangInstanceIdentifier.PathArgument identifier;

        EmptyDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier) {
            this.identifier = (YangInstanceIdentifier.PathArgument)Preconditions.checkNotNull((Object)identifier, (Object)"Identifier should not be null");
        }

        @Nonnull
        public YangInstanceIdentifier.PathArgument getIdentifier() {
            return this.identifier;
        }

        @Nonnull
        public Collection<DataTreeCandidateNode> getChildNodes() {
            return Collections.emptySet();
        }

        @Nullable
        public DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
            return null;
        }

        @Nonnull
        public ModificationType getModificationType() {
            return ModificationType.UNMODIFIED;
        }

        @Nonnull
        public Optional<NormalizedNode<?, ?>> getDataAfter() {
            return Optional.absent();
        }

        @Nonnull
        public Optional<NormalizedNode<?, ?>> getDataBefore() {
            return Optional.absent();
        }
    }

    private final class DOMDataTreeListenerWithSubshards
    implements org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener {
        private final YangInstanceIdentifier listenerPath;
        private final org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener delegate;
        private final Map<YangInstanceIdentifier, ListenerRegistration<org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener>> registrations = new ConcurrentHashMap<YangInstanceIdentifier, ListenerRegistration<org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener>>();
        @GuardedBy(value="this")
        private final Collection<DataTreeCandidate> stashedDataTreeCandidates = new LinkedList<DataTreeCandidate>();

        DOMDataTreeListenerWithSubshards(YangInstanceIdentifier listenerPath, org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener delegate) {
            this.listenerPath = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)listenerPath);
            this.delegate = (org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener)Preconditions.checkNotNull((Object)delegate);
        }

        public synchronized void onDataTreeChanged(@Nonnull Collection<DataTreeCandidate> changes) {
            LOG.debug("Received data changed {}", changes);
            if (!this.stashedDataTreeCandidates.isEmpty()) {
                LOG.debug("Adding stashed subshards' changes {}", this.stashedDataTreeCandidates);
                changes.addAll(this.stashedDataTreeCandidates);
                this.stashedDataTreeCandidates.clear();
            }
            try {
                DistributedShardChangePublisher.this.applyChanges(this.listenerPath, changes);
            }
            catch (DataValidationFailedException e) {
                LOG.error("Validation failed for modification built from changes {}, current data tree: {}", new Object[]{changes, DistributedShardChangePublisher.this.dataTree, e});
                throw new RuntimeException("Notification validation failed", e);
            }
            this.delegate.onDataTreeChanged(changes);
        }

        synchronized void onDataTreeChanged(YangInstanceIdentifier pathFromRoot, Collection<DataTreeCandidate> changes) {
            YangInstanceIdentifier changeId = YangInstanceIdentifier.create((Iterable)DistributedShardChangePublisher.stripShardPath(DistributedShardChangePublisher.this.dataTree.getRootPath(), pathFromRoot));
            List<DataTreeCandidate> newCandidates = changes.stream().map(candidate -> DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)changeId, (DataTreeCandidateNode)candidate.getRootNode())).collect(Collectors.toList());
            try {
                this.delegate.onDataTreeChanged(Collections.singleton(DistributedShardChangePublisher.this.applyChanges(this.listenerPath, newCandidates)));
            }
            catch (DataValidationFailedException e) {
                LOG.debug("Validation for modification built from subshard {} changes {} failed, current data tree {}.", new Object[]{pathFromRoot, changes, DistributedShardChangePublisher.this.dataTree});
                this.stashedDataTreeCandidates.addAll(newCandidates);
            }
        }

        void addSubshard(ChildShardContext context) {
            Preconditions.checkState((boolean)(context.getShard() instanceof DOMStoreTreeChangePublisher), (Object)"All subshards that are initialDataChangeEvent part of ListenerContext need to be listenable");
            DOMStoreTreeChangePublisher listenableShard = (DOMStoreTreeChangePublisher)context.getShard();
            this.registrations.put(context.getPrefix().getRootIdentifier(), (ListenerRegistration<org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener>)listenableShard.registerTreeChangeListener(context.getPrefix().getRootIdentifier(), changes -> this.onDataTreeChanged(context.getPrefix().getRootIdentifier(), changes)));
        }

        void close() {
            for (ListenerRegistration<org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener> registration : this.registrations.values()) {
                registration.close();
            }
            this.registrations.clear();
        }
    }

    private static class ProxyRegistration
    implements ListenerRegistration<org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener> {
        private final ListenerRegistration<DOMDataTreeChangeListener> proxy;
        private final org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener listener;

        private ProxyRegistration(ListenerRegistration<DOMDataTreeChangeListener> proxy, org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener listener) {
            this.proxy = proxy;
            this.listener = listener;
        }

        public org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener getInstance() {
            return this.listener;
        }

        public void close() {
            this.proxy.close();
        }
    }
}

