/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.Status;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.sharding.DOMDataTreeShardCreationFailedException;

@NotThreadSafe
abstract class LookupTask
implements Runnable {
    private final int maxRetries;
    private final ActorRef replyTo;
    private int retries = 0;

    LookupTask(ActorRef replyTo, int maxRetries) {
        this.replyTo = replyTo;
        this.maxRetries = maxRetries;
    }

    abstract void reschedule(int var1);

    void tryReschedule(@Nullable Throwable throwable) {
        if (this.retries <= this.maxRetries) {
            ++this.retries;
            this.reschedule(this.retries);
        } else {
            this.fail(throwable);
        }
    }

    void fail(@Nullable Throwable throwable) {
        if (throwable == null) {
            this.replyTo.tell((Object)new Status.Failure((Throwable)new DOMDataTreeShardCreationFailedException("Unable to find the backend shard.Failing..")), ActorRef.noSender());
        } else {
            this.replyTo.tell((Object)new Status.Failure((Throwable)new DOMDataTreeShardCreationFailedException("Unable to find the backend shard.Failing..", throwable)), ActorRef.noSender());
        }
    }
}

