/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.config.PrefixShardConfiguration;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardCreated;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardRemoved;
import org.opendaylight.controller.md.sal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixedShardConfigUpdateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixedShardConfigUpdateHandler.class);
    private final ActorRef handlingActor;
    private final MemberName memberName;
    private final EnumMap<LogicalDatastoreType, ListenerRegistration<DOMDataTreeChangeListener>> registrations = new EnumMap(LogicalDatastoreType.class);

    public PrefixedShardConfigUpdateHandler(ActorRef handlingActor, MemberName memberName) {
        this.handlingActor = (ActorRef)Preconditions.checkNotNull((Object)handlingActor);
        this.memberName = (MemberName)Preconditions.checkNotNull((Object)memberName);
    }

    public void initListener(AbstractDataStore dataStore, LogicalDatastoreType type) {
        this.registrations.put(type, dataStore.registerShardConfigListener(ClusterUtils.SHARD_LIST_PATH, (DOMDataTreeChangeListener)new ShardConfigHandler(this.memberName, type, this.handlingActor)));
    }

    public void close() {
        this.registrations.values().forEach(ListenerRegistration::close);
        this.registrations.clear();
    }

    public static final class ShardConfigHandler
    implements ClusteredDOMDataTreeChangeListener {
        private final MemberName memberName;
        private final LogicalDatastoreType type;
        private final ActorRef handlingActor;
        private final String logName;

        public ShardConfigHandler(MemberName memberName, LogicalDatastoreType type, ActorRef handlingActor) {
            this.memberName = memberName;
            this.type = type;
            this.handlingActor = handlingActor;
            this.logName = memberName.getName() + "-" + type;
        }

        public void onDataTreeChanged(@Nonnull Collection<DataTreeCandidate> changes) {
            changes.forEach(this::resolveChange);
        }

        private void resolveChange(DataTreeCandidate candidate) {
            switch (candidate.getRootNode().getModificationType()) {
                case UNMODIFIED: {
                    break;
                }
                case SUBTREE_MODIFIED: 
                case APPEARED: 
                case WRITE: {
                    this.resolveWrite(candidate.getRootNode());
                    break;
                }
                case DELETE: 
                case DISAPPEARED: {
                    this.resolveDelete(candidate.getRootNode());
                    break;
                }
            }
        }

        private void resolveWrite(DataTreeCandidateNode rootNode) {
            LOG.debug("{}: New config received {}", (Object)this.logName, (Object)rootNode);
            LOG.debug("{}: Data after: {}", (Object)this.logName, (Object)rootNode.getDataAfter());
            for (DataTreeCandidateNode childNode : rootNode.getChildNodes()) {
                switch (childNode.getModificationType()) {
                    case UNMODIFIED: {
                        break;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case WRITE: {
                        this.resolveWrittenShard(childNode);
                        break;
                    }
                    case DELETE: 
                    case DISAPPEARED: {
                        this.resolveDeletedShard(childNode);
                        break;
                    }
                }
            }
        }

        private void resolveWrittenShard(DataTreeCandidateNode childNode) {
            MapEntryNode entryNode = (MapEntryNode)childNode.getDataAfter().get();
            LeafNode prefix = (LeafNode)entryNode.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_PREFIX_QNAME)).get();
            YangInstanceIdentifier identifier = (YangInstanceIdentifier)prefix.getValue();
            LOG.debug("{}: Deserialized {} from datastore", (Object)this.logName, (Object)identifier);
            ContainerNode replicas = (ContainerNode)entryNode.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_REPLICAS_QNAME)).get();
            LeafSetNode replicaList = (LeafSetNode)replicas.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_REPLICA_QNAME)).get();
            List<MemberName> retReplicas = replicaList.getValue().stream().map(child -> MemberName.forName((String)((String)child.getValue()))).collect(Collectors.toList());
            LOG.debug("{}: Replicas read from ds {}", (Object)this.logName, (Object)retReplicas.toString());
            PrefixShardConfiguration newConfig = new PrefixShardConfiguration(new DOMDataTreeIdentifier(this.type, identifier), "prefix", retReplicas);
            LOG.debug("{}: Resulting config {} - sending PrefixShardCreated to {}", new Object[]{this.logName, newConfig, this.handlingActor});
            this.handlingActor.tell((Object)new PrefixShardCreated(newConfig), ActorRef.noSender());
        }

        private void resolveDeletedShard(DataTreeCandidateNode childNode) {
            MapEntryNode entryNode = (MapEntryNode)childNode.getDataBefore().get();
            LeafNode prefix = (LeafNode)entryNode.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ClusterUtils.SHARD_PREFIX_QNAME)).get();
            YangInstanceIdentifier deleted = (YangInstanceIdentifier)prefix.getValue();
            LOG.debug("{}: Removing shard at {}.", (Object)this.memberName, (Object)deleted);
            DOMDataTreeIdentifier domDataTreeIdentifier = new DOMDataTreeIdentifier(this.type, deleted);
            PrefixShardRemoved message = new PrefixShardRemoved(domDataTreeIdentifier);
            this.handlingActor.tell((Object)message, ActorRef.noSender());
        }

        private void resolveDelete(DataTreeCandidateNode rootNode) {
        }

        public String toString() {
            return "ShardConfigHandler [logName=" + this.logName + ", handlingActor=" + this.handlingActor + "]";
        }
    }
}

