/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.Props;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.dom.api.LeaderLocation;
import org.opendaylight.controller.cluster.dom.api.LeaderLocationListener;
import org.opendaylight.controller.cluster.notifications.LeaderStateChanged;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.notifications.RoleChangeNotification;

public class RoleChangeListenerActor
extends AbstractUntypedActor {
    private final LeaderLocationListener leaderLocationListener;
    private final ActorRef roleChangeNotifier;

    private RoleChangeListenerActor(ActorRef roleChangeNotifier, LeaderLocationListener listener) {
        this.roleChangeNotifier = (ActorRef)Preconditions.checkNotNull((Object)roleChangeNotifier);
        this.leaderLocationListener = (LeaderLocationListener)Preconditions.checkNotNull((Object)listener);
    }

    public void preStart() throws Exception {
        super.preStart();
        this.roleChangeNotifier.tell((Object)new RegisterRoleChangeListener(), this.getSelf());
    }

    protected void handleReceive(Object message) throws Exception {
        if (message instanceof RoleChangeNotification) {
            this.ignoreMessage(message);
        } else if (message instanceof LeaderStateChanged) {
            this.onLeaderStateChanged((LeaderStateChanged)message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void onLeaderStateChanged(LeaderStateChanged message) {
        LeaderLocation newLocation = message.getLeaderId() == null ? LeaderLocation.UNKNOWN : (message.getMemberId().equals(message.getLeaderId()) ? LeaderLocation.LOCAL : LeaderLocation.REMOTE);
        this.leaderLocationListener.onLeaderLocationChanged(newLocation);
    }

    public static Props props(ActorRef roleChangeNotifier, LeaderLocationListener listener) {
        return Props.create(RoleChangeListenerActor.class, (Object[])new Object[]{roleChangeNotifier, listener});
    }
}

