/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.sharding.DistributedShardModificationFactory;
import org.opendaylight.controller.cluster.sharding.ShardProxyTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataTreeShard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardProxyProducer
implements DOMDataTreeShardProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMDataTreeShard.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final DOMDataTreeIdentifier shardRoot;
    private final Collection<DOMDataTreeIdentifier> prefixes;
    private final ClientLocalHistory history;
    private DistributedShardModificationFactory modificationFactory;

    ShardProxyProducer(DOMDataTreeIdentifier shardRoot, Collection<DOMDataTreeIdentifier> prefixes, DataStoreClient client, DistributedShardModificationFactory modificationFactory) {
        this.shardRoot = (DOMDataTreeIdentifier)Preconditions.checkNotNull((Object)shardRoot);
        this.prefixes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(prefixes)));
        this.modificationFactory = (DistributedShardModificationFactory)Preconditions.checkNotNull((Object)modificationFactory);
        this.history = ((DataStoreClient)Preconditions.checkNotNull((Object)client)).createLocalHistory();
    }

    @Nonnull
    public Collection<DOMDataTreeIdentifier> getPrefixes() {
        return this.prefixes;
    }

    public DOMDataTreeShardWriteTransaction createTransaction() {
        return new ShardProxyTransaction(this.shardRoot, this.prefixes, this.modificationFactory.createModification(this.history.createTransaction()));
    }

    DistributedShardModificationFactory getModificationFactory() {
        return this.modificationFactory;
    }

    void setModificationFactory(DistributedShardModificationFactory modificationFactory) {
        this.modificationFactory = (DistributedShardModificationFactory)Preconditions.checkNotNull((Object)modificationFactory);
    }
}

