/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.actor_system_provider.impl;

import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.osgi.BundleDelegatingClassLoader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.security.AccessController;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.ActorSystemProviderListener;
import org.opendaylight.controller.cluster.common.actor.FileAkkaConfigurationReader;
import org.opendaylight.controller.cluster.common.actor.QuarantinedMonitorActor;
import org.opendaylight.controller.cluster.datastore.TerminationMonitor;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

public class ActorSystemProviderImpl
implements ActorSystemProvider,
AutoCloseable {
    private static final String ACTOR_SYSTEM_NAME = "opendaylight-cluster-data";
    private static final String CONFIGURATION_NAME = "odl-cluster-data";
    static final Logger LOG = LoggerFactory.getLogger(ActorSystemProviderImpl.class);
    private final ActorSystem actorSystem;
    private final ListenerRegistry<ActorSystemProviderListener> listeners = new ListenerRegistry();

    public ActorSystemProviderImpl(BundleContext bundleContext) {
        LOG.info("Creating new ActorSystem");
        Bundle bundle = bundleContext.getBundle();
        BundleDelegatingClassLoader classLoader = AccessController.doPrivileged(() -> new BundleDelegatingClassLoader(bundle, Thread.currentThread().getContextClassLoader()));
        FileAkkaConfigurationReader configurationReader = new FileAkkaConfigurationReader();
        Config akkaConfig = ConfigFactory.load((Config)configurationReader.read()).getConfig(CONFIGURATION_NAME);
        this.actorSystem = ActorSystem.create((String)ACTOR_SYSTEM_NAME, (Config)akkaConfig, (ClassLoader)classLoader);
        this.actorSystem.actorOf(Props.create(TerminationMonitor.class, (Object[])new Object[0]), "termination-monitor");
        this.actorSystem.actorOf(QuarantinedMonitorActor.props(() -> {
            LOG.warn("Restarting karaf container");
            System.setProperty("karaf.restart.jvm", "true");
            bundleContext.getBundle(0L).stop();
        }), "quarantined-monitor");
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public ListenerRegistration<ActorSystemProviderListener> registerActorSystemProviderListener(ActorSystemProviderListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    @Override
    public void close() {
        LOG.info("Shutting down ActorSystem");
        try {
            Await.result((Awaitable)this.actorSystem.terminate(), (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        }
        catch (Exception e) {
            LOG.warn("Error awaiting actor termination", (Throwable)e);
        }
    }
}

