/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.actor_system_provider.impl;

import akka.actor.ActorSystem;
import com.google.common.collect.ForwardingObject;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.ActorSystemProviderListener;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.osgi.WaitingServiceTracker;
import org.opendaylight.controller.config.yang.config.actor_system_provider.impl.AbstractActorSystemProviderModule;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.osgi.framework.BundleContext;

public class ActorSystemProviderModule
extends AbstractActorSystemProviderModule {
    private BundleContext bundleContext;

    public ActorSystemProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public ActorSystemProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, ActorSystemProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
    }

    @Override
    public boolean canReuseInstance(AbstractActorSystemProviderModule oldModule) {
        return true;
    }

    public AutoCloseable createInstance() {
        WaitingServiceTracker tracker = WaitingServiceTracker.create(ActorSystemProvider.class, (BundleContext)this.bundleContext);
        ActorSystemProvider delegate = (ActorSystemProvider)tracker.waitForService(WaitingServiceTracker.FIVE_MINUTES);
        return new ForwardingActorSystemProvider(delegate, (AutoCloseable)tracker);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static class ForwardingActorSystemProvider
    extends ForwardingObject
    implements ActorSystemProvider,
    AutoCloseable {
        private final ActorSystemProvider delegate;
        private final AutoCloseable closeable;

        ForwardingActorSystemProvider(ActorSystemProvider delegate, AutoCloseable closeable) {
            this.delegate = delegate;
            this.closeable = closeable;
        }

        public ActorSystem getActorSystem() {
            return this.delegate().getActorSystem();
        }

        public ListenerRegistration<ActorSystemProviderListener> registerActorSystemProviderListener(ActorSystemProviderListener listener) {
            return this.delegate().registerActorSystemProviderListener(listener);
        }

        protected ActorSystemProvider delegate() {
            return this.delegate;
        }

        @Override
        public void close() throws Exception {
            this.closeable.close();
        }
    }
}

