/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DomConcurrentDataBrokerBuilder
implements Builder<DomConcurrentDataBroker> {
    private BigInteger _averageCommit;
    private BigInteger _longestCommitDuration;
    private DateAndTime _longestCommitTimestamp;
    private BigInteger _shortestCommitDuration;
    private DateAndTime _shortestCommitTimestamp;
    private BigInteger _totalCommits;
    Map<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKAVERAGECOMMITRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKLONGESTCOMMITDURATIONRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKSHORTESTCOMMITDURATIONRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTOTALCOMMITSRANGE_RANGES;

    public DomConcurrentDataBrokerBuilder() {
    }

    public DomConcurrentDataBrokerBuilder(DomBrokerOperational arg) {
        this._totalCommits = arg.getTotalCommits();
        this._averageCommit = arg.getAverageCommit();
        this._longestCommitDuration = arg.getLongestCommitDuration();
        this._longestCommitTimestamp = arg.getLongestCommitTimestamp();
        this._shortestCommitDuration = arg.getShortestCommitDuration();
        this._shortestCommitTimestamp = arg.getShortestCommitTimestamp();
    }

    public DomConcurrentDataBrokerBuilder(DomConcurrentDataBroker base) {
        AugmentationHolder casted;
        this._averageCommit = base.getAverageCommit();
        this._longestCommitDuration = base.getLongestCommitDuration();
        this._longestCommitTimestamp = base.getLongestCommitTimestamp();
        this._shortestCommitDuration = base.getShortestCommitDuration();
        this._shortestCommitTimestamp = base.getShortestCommitTimestamp();
        this._totalCommits = base.getTotalCommits();
        if (base instanceof DomConcurrentDataBrokerImpl) {
            DomConcurrentDataBrokerImpl impl = (DomConcurrentDataBrokerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DomBrokerOperational) {
            this._totalCommits = ((DomBrokerOperational)arg).getTotalCommits();
            this._averageCommit = ((DomBrokerOperational)arg).getAverageCommit();
            this._longestCommitDuration = ((DomBrokerOperational)arg).getLongestCommitDuration();
            this._longestCommitTimestamp = ((DomBrokerOperational)arg).getLongestCommitTimestamp();
            this._shortestCommitDuration = ((DomBrokerOperational)arg).getShortestCommitDuration();
            this._shortestCommitTimestamp = ((DomBrokerOperational)arg).getShortestCommitTimestamp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational] \nbut was: " + arg);
        }
    }

    public BigInteger getAverageCommit() {
        return this._averageCommit;
    }

    public BigInteger getLongestCommitDuration() {
        return this._longestCommitDuration;
    }

    public DateAndTime getLongestCommitTimestamp() {
        return this._longestCommitTimestamp;
    }

    public BigInteger getShortestCommitDuration() {
        return this._shortestCommitDuration;
    }

    public DateAndTime getShortestCommitTimestamp() {
        return this._shortestCommitTimestamp;
    }

    public BigInteger getTotalCommits() {
        return this._totalCommits;
    }

    public <E extends Augmentation<DomConcurrentDataBroker>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkAverageCommitRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKAVERAGECOMMITRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKAVERAGECOMMITRANGE_RANGES)));
    }

    public DomConcurrentDataBrokerBuilder setAverageCommit(BigInteger value) {
        if (value != null) {
            DomConcurrentDataBrokerBuilder.checkAverageCommitRange(value);
        }
        this._averageCommit = value;
        return this;
    }

    private static void checkLongestCommitDurationRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKLONGESTCOMMITDURATIONRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKLONGESTCOMMITDURATIONRANGE_RANGES)));
    }

    public DomConcurrentDataBrokerBuilder setLongestCommitDuration(BigInteger value) {
        if (value != null) {
            DomConcurrentDataBrokerBuilder.checkLongestCommitDurationRange(value);
        }
        this._longestCommitDuration = value;
        return this;
    }

    public DomConcurrentDataBrokerBuilder setLongestCommitTimestamp(DateAndTime value) {
        this._longestCommitTimestamp = value;
        return this;
    }

    private static void checkShortestCommitDurationRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKSHORTESTCOMMITDURATIONRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKSHORTESTCOMMITDURATIONRANGE_RANGES)));
    }

    public DomConcurrentDataBrokerBuilder setShortestCommitDuration(BigInteger value) {
        if (value != null) {
            DomConcurrentDataBrokerBuilder.checkShortestCommitDurationRange(value);
        }
        this._shortestCommitDuration = value;
        return this;
    }

    public DomConcurrentDataBrokerBuilder setShortestCommitTimestamp(DateAndTime value) {
        this._shortestCommitTimestamp = value;
        return this;
    }

    private static void checkTotalCommitsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTOTALCOMMITSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTOTALCOMMITSRANGE_RANGES)));
    }

    public DomConcurrentDataBrokerBuilder setTotalCommits(BigInteger value) {
        if (value != null) {
            DomConcurrentDataBrokerBuilder.checkTotalCommitsRange(value);
        }
        this._totalCommits = value;
        return this;
    }

    public DomConcurrentDataBrokerBuilder addAugmentation(Class<? extends Augmentation<DomConcurrentDataBroker>> augmentationType, Augmentation<DomConcurrentDataBroker> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DomConcurrentDataBrokerBuilder removeAugmentation(Class<? extends Augmentation<DomConcurrentDataBroker>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DomConcurrentDataBroker build() {
        return new DomConcurrentDataBrokerImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKAVERAGECOMMITRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKLONGESTCOMMITDURATIONRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKSHORTESTCOMMITDURATIONRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTOTALCOMMITSRANGE_RANGES = a;
    }

    private static final class DomConcurrentDataBrokerImpl
    implements DomConcurrentDataBroker {
        private final BigInteger _averageCommit;
        private final BigInteger _longestCommitDuration;
        private final DateAndTime _longestCommitTimestamp;
        private final BigInteger _shortestCommitDuration;
        private final DateAndTime _shortestCommitTimestamp;
        private final BigInteger _totalCommits;
        private Map<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DomConcurrentDataBroker> getImplementedInterface() {
            return DomConcurrentDataBroker.class;
        }

        private DomConcurrentDataBrokerImpl(DomConcurrentDataBrokerBuilder base) {
            this._averageCommit = base.getAverageCommit();
            this._longestCommitDuration = base.getLongestCommitDuration();
            this._longestCommitTimestamp = base.getLongestCommitTimestamp();
            this._shortestCommitDuration = base.getShortestCommitDuration();
            this._shortestCommitTimestamp = base.getShortestCommitTimestamp();
            this._totalCommits = base.getTotalCommits();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>(base.augmentation);
                }
            }
        }

        public BigInteger getAverageCommit() {
            return this._averageCommit;
        }

        public BigInteger getLongestCommitDuration() {
            return this._longestCommitDuration;
        }

        public DateAndTime getLongestCommitTimestamp() {
            return this._longestCommitTimestamp;
        }

        public BigInteger getShortestCommitDuration() {
            return this._shortestCommitDuration;
        }

        public DateAndTime getShortestCommitTimestamp() {
            return this._shortestCommitTimestamp;
        }

        public BigInteger getTotalCommits() {
            return this._totalCommits;
        }

        public <E extends Augmentation<DomConcurrentDataBroker>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._averageCommit);
            result = 31 * result + Objects.hashCode(this._longestCommitDuration);
            result = 31 * result + Objects.hashCode(this._longestCommitTimestamp);
            result = 31 * result + Objects.hashCode(this._shortestCommitDuration);
            result = 31 * result + Objects.hashCode(this._shortestCommitTimestamp);
            result = 31 * result + Objects.hashCode(this._totalCommits);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DomConcurrentDataBroker.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DomConcurrentDataBroker other = (DomConcurrentDataBroker)obj;
            if (!Objects.equals(this._averageCommit, other.getAverageCommit())) {
                return false;
            }
            if (!Objects.equals(this._longestCommitDuration, other.getLongestCommitDuration())) {
                return false;
            }
            if (!Objects.equals(this._longestCommitTimestamp, other.getLongestCommitTimestamp())) {
                return false;
            }
            if (!Objects.equals(this._shortestCommitDuration, other.getShortestCommitDuration())) {
                return false;
            }
            if (!Objects.equals(this._shortestCommitTimestamp, other.getShortestCommitTimestamp())) {
                return false;
            }
            if (!Objects.equals(this._totalCommits, other.getTotalCommits())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DomConcurrentDataBrokerImpl otherImpl = (DomConcurrentDataBrokerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "DomConcurrentDataBroker [";
            StringBuilder builder = new StringBuilder(name);
            if (this._averageCommit != null) {
                builder.append("_averageCommit=");
                builder.append(this._averageCommit);
                builder.append(", ");
            }
            if (this._longestCommitDuration != null) {
                builder.append("_longestCommitDuration=");
                builder.append(this._longestCommitDuration);
                builder.append(", ");
            }
            if (this._longestCommitTimestamp != null) {
                builder.append("_longestCommitTimestamp=");
                builder.append(this._longestCommitTimestamp);
                builder.append(", ");
            }
            if (this._shortestCommitDuration != null) {
                builder.append("_shortestCommitDuration=");
                builder.append(this._shortestCommitDuration);
                builder.append(", ");
            }
            if (this._shortestCommitTimestamp != null) {
                builder.append("_shortestCommitTimestamp=");
                builder.append(this._shortestCommitTimestamp);
                builder.append(", ");
            }
            if (this._totalCommits != null) {
                builder.append("_totalCommits=");
                builder.append(this._totalCommits);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

