/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class HeartbeatIntervalType
implements Serializable {
    private static final long serialVersionUID = 6964103311731561611L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 100 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[100..65535]].", value));
    }

    @ConstructorProperties(value={"value"})
    public HeartbeatIntervalType(Integer _value) {
        if (_value != null) {
            HeartbeatIntervalType.check_valueRange(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public HeartbeatIntervalType(HeartbeatIntervalType source) {
        this._value = source._value;
    }

    public static HeartbeatIntervalType getDefaultInstance(String defaultValue) {
        return new HeartbeatIntervalType(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeartbeatIntervalType other = (HeartbeatIntervalType)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(HeartbeatIntervalType.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

