/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class OperationTimeoutType
implements Serializable {
    private static final long serialVersionUID = -8895242571909692994L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 5 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[5..65535]].", value));
    }

    @ConstructorProperties(value={"value"})
    public OperationTimeoutType(Integer _value) {
        if (_value != null) {
            OperationTimeoutType.check_valueRange(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public OperationTimeoutType(OperationTimeoutType source) {
        this._value = source._value;
    }

    public static OperationTimeoutType getDefaultInstance(String defaultValue) {
        return new OperationTimeoutType(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationTimeoutType other = (OperationTimeoutType)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(OperationTimeoutType.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

