/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class Percentage
implements Serializable {
    private static final long serialVersionUID = 482899018947419815L;
    private final Short _value;

    private static void check_valueRange(short value) {
        if (value >= 0 && value <= 100) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..100]].", value));
    }

    @ConstructorProperties(value={"value"})
    public Percentage(Short _value) {
        if (_value != null) {
            Percentage.check_valueRange(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public Percentage(Percentage source) {
        this._value = source._value;
    }

    public static Percentage getDefaultInstance(String defaultValue) {
        return new Percentage(Short.valueOf(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percentage other = (Percentage)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Percentage.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

