/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.ShardKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class ShardBuilder
implements Builder<Shard> {
    private ShardKey _key;
    private InstanceIdentifier<?> _prefix;
    private Replicas _replicas;
    Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> augmentation = Collections.emptyMap();

    public ShardBuilder() {
    }

    public ShardBuilder(Shard base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ShardKey(base.getPrefix());
            this._prefix = base.getPrefix();
        } else {
            this._key = base.getKey();
            this._prefix = this._key.getPrefix();
        }
        this._replicas = base.getReplicas();
        if (base instanceof ShardImpl) {
            ShardImpl impl = (ShardImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>(casted.augmentations());
        }
    }

    public ShardKey getKey() {
        return this._key;
    }

    public InstanceIdentifier<?> getPrefix() {
        return this._prefix;
    }

    public Replicas getReplicas() {
        return this._replicas;
    }

    public <E extends Augmentation<Shard>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ShardBuilder setKey(ShardKey value) {
        this._key = value;
        return this;
    }

    public ShardBuilder setPrefix(InstanceIdentifier<?> value) {
        this._prefix = value;
        return this;
    }

    public ShardBuilder setReplicas(Replicas value) {
        this._replicas = value;
        return this;
    }

    public ShardBuilder addAugmentation(Class<? extends Augmentation<Shard>> augmentationType, Augmentation<Shard> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ShardBuilder removeAugmentation(Class<? extends Augmentation<Shard>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Shard build() {
        return new ShardImpl(this);
    }

    private static final class ShardImpl
    implements Shard {
        private final ShardKey _key;
        private final InstanceIdentifier<?> _prefix;
        private final Replicas _replicas;
        private Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Shard> getImplementedInterface() {
            return Shard.class;
        }

        private ShardImpl(ShardBuilder base) {
            if (base.getKey() == null) {
                this._key = new ShardKey(base.getPrefix());
                this._prefix = base.getPrefix();
            } else {
                this._key = base.getKey();
                this._prefix = this._key.getPrefix();
            }
            this._replicas = base.getReplicas();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Shard>>, Augmentation<Shard>>(base.augmentation);
                }
            }
        }

        @Override
        public ShardKey getKey() {
            return this._key;
        }

        @Override
        public InstanceIdentifier<?> getPrefix() {
            return this._prefix;
        }

        @Override
        public Replicas getReplicas() {
            return this._replicas;
        }

        public <E extends Augmentation<Shard>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._prefix);
            result = 31 * result + Objects.hashCode(this._replicas);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Shard.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Shard other = (Shard)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._prefix, other.getPrefix())) {
                return false;
            }
            if (!Objects.equals(this._replicas, other.getReplicas())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ShardImpl otherImpl = (ShardImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Shard [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._prefix != null) {
                builder.append("_prefix=");
                builder.append(this._prefix);
                builder.append(", ");
            }
            if (this._replicas != null) {
                builder.append("_replicas=");
                builder.append(this._replicas);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

