/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.opendaylight.controller.cluster.databroker.DOMBrokerReadOnlyTransaction;
import org.opendaylight.controller.cluster.databroker.DOMBrokerReadWriteTransaction;
import org.opendaylight.controller.cluster.databroker.DOMBrokerWriteOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionFactory;

public abstract class AbstractDOMTransactionFactory<T extends DOMStoreTransactionFactory>
implements AutoCloseable {
    private static final AtomicIntegerFieldUpdater<AbstractDOMTransactionFactory> UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractDOMTransactionFactory.class, "closed");
    private final Map<LogicalDatastoreType, T> storeTxFactories;
    private volatile int closed = 0;

    protected AbstractDOMTransactionFactory(Map<LogicalDatastoreType, T> txFactories) {
        this.storeTxFactories = new EnumMap<LogicalDatastoreType, T>(txFactories);
    }

    protected abstract Object newTransactionIdentifier();

    protected abstract CheckedFuture<Void, TransactionCommitFailedException> submit(DOMDataWriteTransaction var1, Collection<DOMStoreThreePhaseCommitCohort> var2);

    public final DOMDataReadOnlyTransaction newReadOnlyTransaction() {
        this.checkNotClosed();
        return new DOMBrokerReadOnlyTransaction(this.newTransactionIdentifier(), this.storeTxFactories);
    }

    public final DOMDataWriteTransaction newWriteOnlyTransaction() {
        this.checkNotClosed();
        return new DOMBrokerWriteOnlyTransaction(this.newTransactionIdentifier(), this.storeTxFactories, this);
    }

    public final DOMDataReadWriteTransaction newReadWriteTransaction() {
        this.checkNotClosed();
        return new DOMBrokerReadWriteTransaction(this.newTransactionIdentifier(), this.storeTxFactories, this);
    }

    protected final Map<LogicalDatastoreType, T> getTxFactories() {
        return this.storeTxFactories;
    }

    protected final void checkNotClosed() {
        Preconditions.checkState((this.closed == 0 ? 1 : 0) != 0, (Object)"Transaction factory was closed. No further operations allowed.");
    }

    @Override
    public void close() {
        boolean success = UPDATER.compareAndSet(this, 0, 1);
        Preconditions.checkState((boolean)success, (Object)"Transaction factory was already closed");
    }
}

