/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransactionChain;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class ClientBackedReadTransaction
extends ClientBackedTransaction<ClientSnapshot>
implements DOMStoreReadTransaction {
    private static final AtomicReferenceFieldUpdater<ClientBackedReadTransaction, ClientBackedTransactionChain> PARENT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ClientBackedReadTransaction.class, ClientBackedTransactionChain.class, "parent");
    private volatile ClientBackedTransactionChain parent;

    ClientBackedReadTransaction(ClientSnapshot delegate, @Nullable ClientBackedTransactionChain parent, @Nullable Throwable allocationContext) {
        super(delegate, allocationContext);
        this.parent = parent;
    }

    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(YangInstanceIdentifier path) {
        return Futures.makeChecked(((ClientSnapshot)this.delegate()).read(path), (Function)ReadFailedException.MAPPER);
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(YangInstanceIdentifier path) {
        return Futures.makeChecked(((ClientSnapshot)this.delegate()).exists(path), (Function)ReadFailedException.MAPPER);
    }

    @Override
    public void close() {
        super.close();
        ClientBackedTransactionChain local = PARENT_UPDATER.getAndSet(this, null);
        if (local != null) {
            local.snapshotClosed((ClientSnapshot)this.delegate());
        }
    }
}

