/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.opendaylight.controller.cluster.databroker.AbstractDOMBroker;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.ShardLeaderNotRespondingException;
import org.opendaylight.controller.md.sal.common.api.data.DataStoreUnavailableException;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.TransactionCommitFailedExceptionMapper;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.common.api.MappingCheckedFuture;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ConcurrentDOMDataBroker
extends AbstractDOMBroker {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentDOMDataBroker.class);
    private static final String CAN_COMMIT = "CAN_COMMIT";
    private static final String PRE_COMMIT = "PRE_COMMIT";
    private static final String COMMIT = "COMMIT";
    private final DurationStatisticsTracker commitStatsTracker;
    private final Executor clientFutureCallbackExecutor;

    public ConcurrentDOMDataBroker(Map<LogicalDatastoreType, DOMStore> datastores, Executor listenableFutureExecutor) {
        this(datastores, listenableFutureExecutor, DurationStatisticsTracker.createConcurrent());
    }

    public ConcurrentDOMDataBroker(Map<LogicalDatastoreType, DOMStore> datastores, Executor listenableFutureExecutor, DurationStatisticsTracker commitStatsTracker) {
        super(datastores);
        this.clientFutureCallbackExecutor = (Executor)Preconditions.checkNotNull((Object)listenableFutureExecutor);
        this.commitStatsTracker = (DurationStatisticsTracker)Preconditions.checkNotNull((Object)commitStatsTracker);
    }

    public DurationStatisticsTracker getCommitStatsTracker() {
        return this.commitStatsTracker;
    }

    @Override
    protected CheckedFuture<Void, TransactionCommitFailedException> submit(DOMDataWriteTransaction transaction, Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        Preconditions.checkArgument((transaction != null ? 1 : 0) != 0, (Object)"Transaction must not be null.");
        Preconditions.checkArgument((cohorts != null ? 1 : 0) != 0, (Object)"Cohorts must not be null.");
        LOG.debug("Tx: {} is submitted for execution.", transaction.getIdentifier());
        if (cohorts.isEmpty()) {
            return Futures.immediateCheckedFuture(null);
        }
        AsyncNotifyingSettableFuture clientSubmitFuture = new AsyncNotifyingSettableFuture(this.clientFutureCallbackExecutor);
        this.doCanCommit(clientSubmitFuture, transaction, cohorts);
        return MappingCheckedFuture.create((ListenableFuture)clientSubmitFuture, (Function)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER);
    }

    private void doCanCommit(final AsyncNotifyingSettableFuture clientSubmitFuture, final DOMDataWriteTransaction transaction, final Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        final long startTime = System.nanoTime();
        final Iterator<DOMStoreThreePhaseCommitCohort> cohortIterator = cohorts.iterator();
        FutureCallback<Boolean> futureCallback = new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                if (result == null || !result.booleanValue()) {
                    ConcurrentDOMDataBroker.handleException(clientSubmitFuture, transaction, cohorts, ConcurrentDOMDataBroker.CAN_COMMIT, TransactionCommitFailedExceptionMapper.CAN_COMMIT_ERROR_MAPPER, (Throwable)new TransactionCommitFailedException("Can Commit failed, no detailed cause available.", new RpcError[0]));
                } else if (!cohortIterator.hasNext()) {
                    ConcurrentDOMDataBroker.this.doPreCommit(startTime, clientSubmitFuture, transaction, cohorts);
                } else {
                    Futures.addCallback((ListenableFuture)((DOMStoreThreePhaseCommitCohort)cohortIterator.next()).canCommit(), (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
                }
            }

            public void onFailure(Throwable failure) {
                ConcurrentDOMDataBroker.handleException(clientSubmitFuture, transaction, cohorts, ConcurrentDOMDataBroker.CAN_COMMIT, TransactionCommitFailedExceptionMapper.CAN_COMMIT_ERROR_MAPPER, failure);
            }
        };
        ListenableFuture canCommitFuture = cohortIterator.next().canCommit();
        Futures.addCallback((ListenableFuture)canCommitFuture, (FutureCallback)futureCallback, (Executor)MoreExecutors.directExecutor());
    }

    private void doPreCommit(final long startTime, final AsyncNotifyingSettableFuture clientSubmitFuture, final DOMDataWriteTransaction transaction, final Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        final Iterator<DOMStoreThreePhaseCommitCohort> cohortIterator = cohorts.iterator();
        FutureCallback<Void> futureCallback = new FutureCallback<Void>(){

            public void onSuccess(Void notUsed) {
                if (!cohortIterator.hasNext()) {
                    ConcurrentDOMDataBroker.this.doCommit(startTime, clientSubmitFuture, transaction, cohorts);
                } else {
                    ListenableFuture preCommitFuture = ((DOMStoreThreePhaseCommitCohort)cohortIterator.next()).preCommit();
                    Futures.addCallback((ListenableFuture)preCommitFuture, (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
                }
            }

            public void onFailure(Throwable failure) {
                ConcurrentDOMDataBroker.handleException(clientSubmitFuture, transaction, cohorts, ConcurrentDOMDataBroker.PRE_COMMIT, TransactionCommitFailedExceptionMapper.PRE_COMMIT_MAPPER, failure);
            }
        };
        ListenableFuture preCommitFuture = cohortIterator.next().preCommit();
        Futures.addCallback((ListenableFuture)preCommitFuture, (FutureCallback)futureCallback, (Executor)MoreExecutors.directExecutor());
    }

    private void doCommit(final long startTime, final AsyncNotifyingSettableFuture clientSubmitFuture, final DOMDataWriteTransaction transaction, final Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        final Iterator<DOMStoreThreePhaseCommitCohort> cohortIterator = cohorts.iterator();
        FutureCallback<Void> futureCallback = new FutureCallback<Void>(){

            public void onSuccess(Void notUsed) {
                if (!cohortIterator.hasNext()) {
                    ConcurrentDOMDataBroker.this.commitStatsTracker.addDuration(System.nanoTime() - startTime);
                    clientSubmitFuture.set();
                } else {
                    ListenableFuture commitFuture = ((DOMStoreThreePhaseCommitCohort)cohortIterator.next()).commit();
                    Futures.addCallback((ListenableFuture)commitFuture, (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
                }
            }

            public void onFailure(Throwable throwable) {
                ConcurrentDOMDataBroker.handleException(clientSubmitFuture, transaction, cohorts, ConcurrentDOMDataBroker.COMMIT, TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER, throwable);
            }
        };
        ListenableFuture commitFuture = cohortIterator.next().commit();
        Futures.addCallback((ListenableFuture)commitFuture, (FutureCallback)futureCallback, (Executor)MoreExecutors.directExecutor());
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Pertains to the assignment of the 'clientException' var. FindBugs flags this as an uncomfirmed cast but the generic type in TransactionCommitFailedExceptionMapper is TransactionCommitFailedException and thus should be deemed as confirmed.")
    private static void handleException(AsyncNotifyingSettableFuture clientSubmitFuture, final DOMDataWriteTransaction transaction, Collection<DOMStoreThreePhaseCommitCohort> cohorts, String phase, TransactionCommitFailedExceptionMapper exMapper, Throwable throwable) {
        if (clientSubmitFuture.isDone()) {
            return;
        }
        LOG.debug("Tx: {} Error during phase {}, starting Abort", new Object[]{transaction.getIdentifier(), phase, throwable});
        ListenableFuture[] canCommitFutures = new ListenableFuture[cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : cohorts) {
            canCommitFutures[index++] = cohort.abort();
        }
        Object e = throwable instanceof NoShardLeaderException || throwable instanceof ShardLeaderNotRespondingException ? new DataStoreUnavailableException(throwable.getMessage(), throwable) : (throwable instanceof Exception ? (Exception)throwable : new RuntimeException("Unexpected error occurred", throwable));
        clientSubmitFuture.setException(exMapper.apply((Exception)e));
        ListenableFuture combinedFuture = Futures.allAsList((ListenableFuture[])canCommitFutures);
        Futures.addCallback((ListenableFuture)combinedFuture, (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> notUsed) {
                LOG.debug("Tx: {} aborted successfully", transaction.getIdentifier());
            }

            public void onFailure(Throwable failure) {
                LOG.error("Tx: {} Error during Abort.", transaction.getIdentifier(), (Object)failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public String toString() {
        return "Clustered ConcurrentDOMDataBroker";
    }

    private static class AsyncNotifyingSettableFuture
    extends AbstractFuture<Void> {
        private static final ThreadLocal<Boolean> ON_TASK_COMPLETION_THREAD_TL = new ThreadLocal();
        private final Executor listenerExecutor;

        AsyncNotifyingSettableFuture(Executor listenerExecutor) {
            this.listenerExecutor = (Executor)Preconditions.checkNotNull((Object)listenerExecutor);
        }

        public void addListener(Runnable listener, Executor executor) {
            super.addListener((Runnable)new DelegatingRunnable(listener, this.listenerExecutor), executor);
        }

        boolean set() {
            ON_TASK_COMPLETION_THREAD_TL.set(Boolean.TRUE);
            try {
                boolean bl = super.set(null);
                return bl;
            }
            finally {
                ON_TASK_COMPLETION_THREAD_TL.set(null);
            }
        }

        protected boolean setException(Throwable throwable) {
            ON_TASK_COMPLETION_THREAD_TL.set(Boolean.TRUE);
            try {
                boolean bl = super.setException(throwable);
                return bl;
            }
            finally {
                ON_TASK_COMPLETION_THREAD_TL.set(null);
            }
        }

        private static final class DelegatingRunnable
        implements Runnable {
            private final Runnable delegate;
            private final Executor executor;

            DelegatingRunnable(Runnable delegate, Executor executor) {
                this.delegate = (Runnable)Preconditions.checkNotNull((Object)delegate);
                this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
            }

            @Override
            public void run() {
                if (ON_TASK_COMPLETION_THREAD_TL.get() != null) {
                    LOG.trace("Submitting ListenenableFuture Runnable from thread {} to executor {}", (Object)Thread.currentThread().getName(), (Object)this.executor);
                    this.executor.execute(this.delegate);
                } else {
                    LOG.trace("Executing ListenenableFuture Runnable on this thread: {}", (Object)Thread.currentThread().getName());
                    this.delegate.run();
                }
            }
        }
    }
}

