/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Map;
import org.opendaylight.controller.cluster.databroker.AbstractDOMBrokerTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionFactory;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DOMBrokerReadOnlyTransaction
extends AbstractDOMBrokerTransaction<DOMStoreReadTransaction>
implements DOMDataReadOnlyTransaction {
    protected DOMBrokerReadOnlyTransaction(Object identifier, Map<LogicalDatastoreType, ? extends DOMStoreTransactionFactory> storeTxFactories) {
        super(identifier, storeTxFactories);
    }

    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return ((DOMStoreReadTransaction)this.getSubtransaction(store)).read(path);
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return ((DOMStoreReadTransaction)this.getSubtransaction(store)).exists(path);
    }

    public void close() {
        this.closeSubtransactions();
    }

    @Override
    protected DOMStoreReadTransaction createTransaction(LogicalDatastoreType key) {
        return this.getTxFactory(key).newReadOnlyTransaction();
    }
}

