/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.controller.cluster.databroker.AbstractDOMBroker;
import org.opendaylight.controller.cluster.databroker.AbstractDOMTransactionFactory;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMBrokerTransactionChain
extends AbstractDOMTransactionFactory<DOMStoreTransactionChain>
implements DOMTransactionChain {
    private static final AtomicIntegerFieldUpdater<DOMBrokerTransactionChain> COUNTER_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DOMBrokerTransactionChain.class, "counter");
    private static final AtomicReferenceFieldUpdater<DOMBrokerTransactionChain, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DOMBrokerTransactionChain.class, State.class, "state");
    private static final Logger LOG = LoggerFactory.getLogger(DOMBrokerTransactionChain.class);
    private final AtomicLong txNum = new AtomicLong();
    private final AbstractDOMBroker broker;
    private final TransactionChainListener listener;
    private final long chainId;
    private volatile State state = State.RUNNING;
    private volatile int counter = 0;

    DOMBrokerTransactionChain(long chainId, Map<LogicalDatastoreType, DOMStoreTransactionChain> chains, AbstractDOMBroker broker, TransactionChainListener listener) {
        super(chains);
        this.chainId = chainId;
        this.broker = (AbstractDOMBroker)Preconditions.checkNotNull((Object)broker);
        this.listener = (TransactionChainListener)Preconditions.checkNotNull((Object)listener);
    }

    private void checkNotFailed() {
        Preconditions.checkState((this.state != State.FAILED ? 1 : 0) != 0, (Object)"Transaction chain has failed");
    }

    @Override
    protected Object newTransactionIdentifier() {
        return "DOM-CHAIN-" + this.chainId + "-" + this.txNum.getAndIncrement();
    }

    @Override
    public CheckedFuture<Void, TransactionCommitFailedException> submit(final DOMDataWriteTransaction transaction, Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        this.checkNotFailed();
        this.checkNotClosed();
        CheckedFuture<Void, TransactionCommitFailedException> ret = this.broker.submit(transaction, cohorts);
        COUNTER_UPDATER.incrementAndGet(this);
        Futures.addCallback(ret, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                DOMBrokerTransactionChain.this.transactionCompleted();
            }

            public void onFailure(Throwable failure) {
                DOMBrokerTransactionChain.this.transactionFailed(transaction, failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ret;
    }

    @Override
    public void close() {
        boolean success = STATE_UPDATER.compareAndSet(this, State.RUNNING, State.CLOSING);
        if (!success) {
            LOG.debug("Chain {} is no longer running", (Object)this);
            return;
        }
        super.close();
        for (DOMStoreTransactionChain subChain : this.getTxFactories().values()) {
            subChain.close();
        }
        if (this.counter == 0) {
            this.finishClose();
        }
    }

    private void finishClose() {
        this.state = State.CLOSED;
        this.listener.onTransactionChainSuccessful((TransactionChain)this);
    }

    private void transactionCompleted() {
        if (COUNTER_UPDATER.decrementAndGet(this) == 0 && this.state == State.CLOSING) {
            this.finishClose();
        }
    }

    private void transactionFailed(DOMDataWriteTransaction tx, Throwable cause) {
        this.state = State.FAILED;
        LOG.debug("Transaction chain {}\u00a0failed.", (Object)this, (Object)cause);
        this.listener.onTransactionChainFailed((TransactionChain)this, (AsyncTransaction)tx, cause);
    }

    private static enum State {
        RUNNING,
        CLOSING,
        CLOSED,
        FAILED;

    }
}

