/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public class ClientSnapshot
extends AbstractClientHandle<AbstractProxyTransaction> {
    ClientSnapshot(AbstractClientHistory parent, TransactionIdentifier transactionId) {
        super(parent, transactionId);
    }

    private AbstractProxyTransaction createProxy(Long shard) {
        return this.parent().createSnapshotProxy(this.getIdentifier(), shard);
    }

    private AbstractProxyTransaction ensureSnapshotProxy(YangInstanceIdentifier path) {
        return this.ensureProxy(path, this::createProxy);
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(YangInstanceIdentifier path) {
        return this.ensureSnapshotProxy(path).exists(path);
    }

    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(YangInstanceIdentifier path) {
        return this.ensureSnapshotProxy(path).read(path);
    }
}

