/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransactionCursor;
import org.opendaylight.controller.cluster.databroker.actors.dds.DirectTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.EmptyTransactionCommitCohort;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public class ClientTransaction
extends AbstractClientHandle<AbstractProxyTransaction> {
    private ClientTransactionCursor cursor;

    ClientTransaction(AbstractClientHistory parent, TransactionIdentifier transactionId) {
        super(parent, transactionId);
    }

    private AbstractProxyTransaction createProxy(Long shard) {
        return this.parent().createTransactionProxy(this.getIdentifier(), shard);
    }

    private AbstractProxyTransaction ensureTransactionProxy(YangInstanceIdentifier path) {
        return this.ensureProxy(path, this::createProxy);
    }

    public DOMDataTreeWriteCursor openCursor() {
        Preconditions.checkState((this.cursor == null ? 1 : 0) != 0, (String)"Transaction %s has open cursor", (Object)this.getIdentifier());
        this.cursor = new ClientTransactionCursor(this);
        return this.cursor;
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(YangInstanceIdentifier path) {
        return this.ensureTransactionProxy(path).exists(path);
    }

    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(YangInstanceIdentifier path) {
        return this.ensureTransactionProxy(path).read(path);
    }

    public void delete(YangInstanceIdentifier path) {
        this.ensureTransactionProxy(path).delete(path);
    }

    public void merge(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.ensureTransactionProxy(path).merge(path, data);
    }

    public void write(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.ensureTransactionProxy(path).write(path, data);
    }

    public DOMStoreThreePhaseCommitCohort ready() {
        AbstractTransactionCommitCohort cohort;
        Collection<AbstractProxyTransaction> toReady = this.ensureClosed();
        Preconditions.checkState((toReady != null ? 1 : 0) != 0, (String)"Attempted to submit a closed transaction %s", (Object)this);
        toReady.forEach(AbstractProxyTransaction::seal);
        switch (toReady.size()) {
            case 0: {
                cohort = new EmptyTransactionCommitCohort(this.parent(), this.getIdentifier());
                break;
            }
            case 1: {
                cohort = new DirectTransactionCommitCohort(this.parent(), this.getIdentifier(), (AbstractProxyTransaction)Iterables.getOnlyElement(toReady));
                break;
            }
            default: {
                cohort = new ClientTransactionCommitCohort(this.parent(), this.getIdentifier(), toReady);
            }
        }
        return this.parent().onTransactionReady(this, cohort);
    }

    void closeCursor(@Nonnull DOMDataTreeCursor cursorToClose) {
        if (cursorToClose.equals(this.cursor)) {
            this.cursor = null;
        }
    }
}

