/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
abstract class LocalProxyTransaction
extends AbstractProxyTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(LocalProxyTransaction.class);
    private final TransactionIdentifier identifier;

    LocalProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier, boolean isDone) {
        super(parent, isDone);
        this.identifier = (TransactionIdentifier)Preconditions.checkNotNull((Object)identifier);
    }

    public final TransactionIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    abstract DataTreeSnapshot readOnlyView();

    abstract void applyForwardedModifyTransactionRequest(ModifyTransactionRequest var1, @Nullable Consumer<Response<?, ?>> var2);

    abstract void replayModifyTransactionRequest(ModifyTransactionRequest var1, @Nullable Consumer<Response<?, ?>> var2, long var3);

    @Override
    final CheckedFuture<Boolean, ReadFailedException> doExists(YangInstanceIdentifier path) {
        return Futures.immediateCheckedFuture((Object)this.readOnlyView().readNode(path).isPresent());
    }

    @Override
    final CheckedFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>, ReadFailedException> doRead(YangInstanceIdentifier path) {
        return Futures.immediateCheckedFuture((Object)com.google.common.base.Optional.fromJavaUtil((Optional)this.readOnlyView().readNode(path)));
    }

    final AbortLocalTransactionRequest abortRequest() {
        return new AbortLocalTransactionRequest(this.identifier, this.localActor());
    }

    @Override
    void handleReplayedLocalRequest(AbstractLocalTransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        if (!(request instanceof AbortLocalTransactionRequest)) {
            throw new IllegalArgumentException("Unhandled request" + request);
        }
        this.enqueueAbort((TransactionRequest<?>)request, callback, enqueuedTicks);
    }

    private boolean handleReadRequest(TransactionRequest<?> request, @Nullable Consumer<Response<?, ?>> callback) {
        if (request instanceof ReadTransactionRequest) {
            YangInstanceIdentifier path = ((ReadTransactionRequest)request).getPath();
            com.google.common.base.Optional result = com.google.common.base.Optional.fromJavaUtil((Optional)this.readOnlyView().readNode(path));
            if (callback != null) {
                Consumer fbIsStupid = (Consumer)Preconditions.checkNotNull(callback);
                this.executeInActor(() -> fbIsStupid.accept(new ReadTransactionSuccess((TransactionIdentifier)request.getTarget(), request.getSequence(), result)));
            }
            return true;
        }
        if (request instanceof ExistsTransactionRequest) {
            YangInstanceIdentifier path = ((ExistsTransactionRequest)request).getPath();
            boolean result = this.readOnlyView().readNode(path).isPresent();
            if (callback != null) {
                Consumer fbIsStupid = (Consumer)Preconditions.checkNotNull(callback);
                this.executeInActor(() -> fbIsStupid.accept(new ExistsTransactionSuccess((TransactionIdentifier)request.getTarget(), request.getSequence(), result)));
            }
            return true;
        }
        return false;
    }

    @Override
    void handleReplayedRemoteRequest(TransactionRequest<?> request, @Nullable Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        if (request instanceof ModifyTransactionRequest) {
            this.replayModifyTransactionRequest((ModifyTransactionRequest)request, callback, enqueuedTicks);
        } else if (!this.handleReadRequest(request, callback)) {
            if (request instanceof TransactionPurgeRequest) {
                this.enqueuePurge(callback, enqueuedTicks);
            } else if (request instanceof IncrementTransactionSequenceRequest) {
                LOG.debug("Not replaying {}", request);
            } else {
                throw new IllegalArgumentException("Unhandled request " + request);
            }
        }
    }

    void handleForwardedRemoteRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof ModifyTransactionRequest) {
            this.applyForwardedModifyTransactionRequest((ModifyTransactionRequest)request, callback);
        } else if (!this.handleReadRequest(request, callback)) {
            if (request instanceof TransactionPurgeRequest) {
                this.enqueuePurge(callback);
            } else {
                throw new IllegalArgumentException("Unhandled request " + request);
            }
        }
    }

    @Override
    final void forwardToRemote(final RemoteProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof CommitLocalTransactionRequest) {
            CommitLocalTransactionRequest req = (CommitLocalTransactionRequest)request;
            DataTreeModification mod = req.getModification();
            LOG.debug("Applying modification {} to successor {}", (Object)mod, (Object)successor);
            mod.applyToCursor((DataTreeModificationCursor)new AbstractDataTreeModificationCursor(){

                public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                    successor.write(this.current().node(child), data);
                }

                public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                    successor.merge(this.current().node(child), data);
                }

                public void delete(YangInstanceIdentifier.PathArgument child) {
                    successor.delete(this.current().node(child));
                }
            });
            successor.sealOnly();
            ModifyTransactionRequest successorReq = successor.commitRequest(req.isCoordinated());
            successor.sendRequest((TransactionRequest<?>)successorReq, callback);
        } else if (request instanceof AbortLocalTransactionRequest) {
            LOG.debug("Forwarding abort {} to successor {}", request, (Object)successor);
            successor.abort();
        } else if (request instanceof TransactionPurgeRequest) {
            LOG.debug("Forwarding purge {} to successor {}", request, (Object)successor);
            successor.enqueuePurge(callback);
        } else if (request instanceof ModifyTransactionRequest) {
            successor.handleForwardedRequest(request, callback);
        } else {
            LocalProxyTransaction.throwUnhandledRequest(request);
        }
    }

    @Override
    void forwardToLocal(LocalProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof AbortLocalTransactionRequest) {
            successor.sendAbort(request, callback);
        } else if (request instanceof TransactionPurgeRequest) {
            successor.enqueuePurge(callback);
        } else {
            LocalProxyTransaction.throwUnhandledRequest(request);
        }
        LOG.debug("Forwarded request {} to successor {}", request, (Object)successor);
    }

    private static void throwUnhandledRequest(TransactionRequest<?> request) {
        throw new IllegalArgumentException("Unhandled request" + request);
    }

    void sendAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        this.sendRequest(request, callback);
    }

    void enqueueAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.enqueueRequest(request, callback, enqueuedTicks);
    }
}

