/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.mdsal.common.api.MappingCheckedFuture;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemoteProxyTransaction
extends AbstractProxyTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteProxyTransaction.class);
    private static final int REQUEST_MAX_MODIFICATIONS = 1000;
    private final ModifyTransactionRequestBuilder builder;
    private final boolean sendReadyOnSeal;
    private final boolean snapshotOnly;
    private boolean builderBusy;
    private volatile Exception operationFailure;

    RemoteProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier, boolean snapshotOnly, boolean sendReadyOnSeal, boolean isDone) {
        super(parent, isDone);
        this.snapshotOnly = snapshotOnly;
        this.sendReadyOnSeal = sendReadyOnSeal;
        this.builder = new ModifyTransactionRequestBuilder(identifier, this.localActor());
    }

    @Override
    boolean isSnapshotOnly() {
        return this.snapshotOnly;
    }

    public TransactionIdentifier getIdentifier() {
        return this.builder.getIdentifier();
    }

    @Override
    void doDelete(YangInstanceIdentifier path) {
        this.appendModification((TransactionModification)new TransactionDelete(path), (com.google.common.base.Optional<Long>)com.google.common.base.Optional.absent());
    }

    @Override
    void doMerge(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.appendModification((TransactionModification)new TransactionMerge(path, data), (com.google.common.base.Optional<Long>)com.google.common.base.Optional.absent());
    }

    @Override
    void doWrite(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.appendModification((TransactionModification)new TransactionWrite(path, data), (com.google.common.base.Optional<Long>)com.google.common.base.Optional.absent());
    }

    private <T> CheckedFuture<T, ReadFailedException> sendReadRequest(AbstractReadTransactionRequest<?> request, Consumer<Response<?, ?>> completer, ListenableFuture<T> future) {
        Exception local = this.operationFailure;
        if (local != null) {
            return Futures.immediateFailedCheckedFuture((Exception)new ReadFailedException("Previous operation failed", (Throwable)local, new RpcError[0]));
        }
        this.ensureFlushedBuider();
        this.sendRequest((TransactionRequest<?>)request, completer);
        return MappingCheckedFuture.create(future, (Function)ReadFailedException.MAPPER);
    }

    @Override
    CheckedFuture<Boolean, ReadFailedException> doExists(YangInstanceIdentifier path) {
        SettableFuture future = SettableFuture.create();
        return this.sendReadRequest((AbstractReadTransactionRequest<?>)new ExistsTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), path, this.isSnapshotOnly()), t -> this.completeExists((SettableFuture<Boolean>)future, (Response<?, ?>)t), (ListenableFuture)future);
    }

    @Override
    CheckedFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>, ReadFailedException> doRead(YangInstanceIdentifier path) {
        SettableFuture future = SettableFuture.create();
        return this.sendReadRequest((AbstractReadTransactionRequest<?>)new ReadTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), path, this.isSnapshotOnly()), t -> this.completeRead((SettableFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>>)future, (Response<?, ?>)t), (ListenableFuture)future);
    }

    private void ensureInitializedBuilder() {
        if (!this.builderBusy) {
            this.builder.setSequence(this.nextSequence());
            this.builderBusy = true;
        }
    }

    private void ensureFlushedBuider() {
        this.ensureFlushedBuider((com.google.common.base.Optional<Long>)com.google.common.base.Optional.absent());
    }

    private void ensureFlushedBuider(com.google.common.base.Optional<Long> enqueuedTicks) {
        if (this.builderBusy) {
            this.flushBuilder(enqueuedTicks);
        }
    }

    private void flushBuilder(com.google.common.base.Optional<Long> enqueuedTicks) {
        ModifyTransactionRequest request = this.builder.build();
        this.builderBusy = false;
        this.sendModification((TransactionRequest<?>)request, enqueuedTicks);
    }

    private void sendModification(TransactionRequest<?> request, com.google.common.base.Optional<Long> enqueuedTicks) {
        if (enqueuedTicks.isPresent()) {
            this.enqueueRequest(request, response -> this.completeModify(request, (Response<?, ?>)response), (Long)enqueuedTicks.get());
        } else {
            this.sendRequest(request, response -> this.completeModify(request, (Response<?, ?>)response));
        }
    }

    private void appendModification(TransactionModification modification) {
        this.appendModification(modification, (com.google.common.base.Optional<Long>)com.google.common.base.Optional.absent());
    }

    private void appendModification(TransactionModification modification, com.google.common.base.Optional<Long> enqueuedTicks) {
        if (this.operationFailure == null) {
            this.ensureInitializedBuilder();
            this.builder.addModification(modification);
            if (this.builder.size() >= 1000) {
                this.flushBuilder(enqueuedTicks);
            }
        } else {
            LOG.debug("Transaction {} failed, not attempting further transactions", (Object)this.getIdentifier());
        }
    }

    private void completeModify(TransactionRequest<?> request, Response<?, ?> response) {
        LOG.debug("Modification request {} completed with {}", request, response);
        if (response instanceof TransactionSuccess) {
            this.recordSuccessfulRequest(request);
        } else {
            this.recordFailedResponse(response);
        }
    }

    private Exception recordFailedResponse(Response<?, ?> response) {
        Throwable failure;
        if (response instanceof RequestFailure) {
            failure = ((RequestFailure)response).getCause();
        } else {
            LOG.warn("Unhandled response {}", response);
            failure = new IllegalArgumentException("Unhandled response " + response.getClass());
        }
        if (this.operationFailure == null) {
            LOG.debug("Transaction {} failed", (Object)this.getIdentifier(), (Object)failure);
            this.operationFailure = failure;
        }
        return failure;
    }

    private void failFuture(SettableFuture<?> future, Response<?, ?> response) {
        future.setException((Throwable)this.recordFailedResponse(response));
    }

    private void completeExists(SettableFuture<Boolean> future, Response<?, ?> response) {
        LOG.debug("Exists request completed with {}", response);
        if (response instanceof ExistsTransactionSuccess) {
            future.set((Object)((ExistsTransactionSuccess)response).getExists());
        } else {
            this.failFuture(future, response);
        }
        this.recordFinishedRequest(response);
    }

    private void completeRead(SettableFuture<com.google.common.base.Optional<NormalizedNode<?, ?>>> future, Response<?, ?> response) {
        LOG.debug("Read request completed with {}", response);
        if (response instanceof ReadTransactionSuccess) {
            future.set((Object)((ReadTransactionSuccess)response).getData());
        } else {
            this.failFuture(future, response);
        }
        this.recordFinishedRequest(response);
    }

    ModifyTransactionRequest abortRequest() {
        this.ensureInitializedBuilder();
        this.builder.setAbort();
        this.builderBusy = false;
        return this.builder.build();
    }

    ModifyTransactionRequest commitRequest(boolean coordinated) {
        this.ensureInitializedBuilder();
        this.builder.setCommit(coordinated);
        this.builderBusy = false;
        return this.builder.build();
    }

    private ModifyTransactionRequest readyRequest() {
        this.ensureInitializedBuilder();
        this.builder.setReady();
        this.builderBusy = false;
        return this.builder.build();
    }

    @Override
    boolean sealAndSend(com.google.common.base.Optional<Long> enqueuedTicks) {
        if (this.sendReadyOnSeal) {
            this.ensureInitializedBuilder();
            this.builder.setReady();
            this.flushBuilder(enqueuedTicks);
        }
        return super.sealAndSend(enqueuedTicks);
    }

    @Override
    Optional<ModifyTransactionRequest> flushState() {
        if (!this.builderBusy) {
            return Optional.empty();
        }
        ModifyTransactionRequest request = this.builder.build();
        this.builderBusy = false;
        return Optional.of(request);
    }

    @Override
    void forwardToRemote(RemoteProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        successor.handleForwardedRequest(request, callback);
    }

    void handleForwardedRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof ModifyTransactionRequest) {
            this.handleForwardedModifyTransactionRequest(callback, (ModifyTransactionRequest)request);
        } else if (request instanceof ReadTransactionRequest) {
            this.ensureFlushedBuider();
            this.sendRequest((TransactionRequest<?>)new ReadTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), ((ReadTransactionRequest)request).getPath(), this.isSnapshotOnly()), resp -> {
                this.recordFinishedRequest((Response<?, ?>)resp);
                callback.accept((Response<?, ?>)resp);
            });
        } else if (request instanceof ExistsTransactionRequest) {
            this.ensureFlushedBuider();
            this.sendRequest((TransactionRequest<?>)new ExistsTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), ((ExistsTransactionRequest)request).getPath(), this.isSnapshotOnly()), resp -> {
                this.recordFinishedRequest((Response<?, ?>)resp);
                callback.accept((Response<?, ?>)resp);
            });
        } else if (request instanceof TransactionPreCommitRequest) {
            this.ensureFlushedBuider();
            TransactionPreCommitRequest tmp = new TransactionPreCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor());
            this.sendRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleForwardedRequest$6((TransactionRequest)tmp, callback, arg_0));
        } else if (request instanceof TransactionDoCommitRequest) {
            this.ensureFlushedBuider();
            this.sendRequest((TransactionRequest<?>)new TransactionDoCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback);
        } else if (request instanceof TransactionAbortRequest) {
            this.ensureFlushedBuider();
            this.sendDoAbort(callback);
        } else if (request instanceof TransactionPurgeRequest) {
            this.enqueuePurge(callback);
        } else {
            throw new IllegalArgumentException("Unhandled request {}" + request);
        }
    }

    private void handleForwardedModifyTransactionRequest(Consumer<Response<?, ?>> callback, ModifyTransactionRequest req) {
        req.getModifications().forEach(this::appendModification);
        Optional maybeProto = req.getPersistenceProtocol();
        if (maybeProto.isPresent()) {
            if (this.markSealed()) {
                this.sealOnly();
            }
            switch ((PersistenceProtocol)maybeProto.get()) {
                case ABORT: {
                    ModifyTransactionRequest tmp = this.abortRequest();
                    this.sendRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleForwardedModifyTransactionRequest$7((TransactionRequest)tmp, callback, arg_0));
                    break;
                }
                case SIMPLE: {
                    ModifyTransactionRequest tmp = this.commitRequest(false);
                    this.sendRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleForwardedModifyTransactionRequest$8((TransactionRequest)tmp, callback, arg_0));
                    break;
                }
                case THREE_PHASE: {
                    ModifyTransactionRequest tmp = this.commitRequest(true);
                    this.sendRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleForwardedModifyTransactionRequest$9((TransactionRequest)tmp, callback, arg_0));
                    break;
                }
                case READY: {
                    ModifyTransactionRequest tmp = this.readyRequest();
                    this.sendRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleForwardedModifyTransactionRequest$10((TransactionRequest)tmp, callback, arg_0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled protocol " + maybeProto.get());
                }
            }
        }
    }

    @Override
    void forwardToLocal(LocalProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        successor.handleForwardedRemoteRequest(request, callback);
    }

    @Override
    void handleReplayedLocalRequest(AbstractLocalTransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        if (request instanceof CommitLocalTransactionRequest) {
            this.replayLocalCommitRequest((CommitLocalTransactionRequest)request, callback, enqueuedTicks);
        } else if (request instanceof AbortLocalTransactionRequest) {
            this.enqueueRequest((TransactionRequest<?>)this.abortRequest(), callback, enqueuedTicks);
        } else {
            throw new IllegalStateException("Unhandled request " + request);
        }
    }

    private void replayLocalCommitRequest(CommitLocalTransactionRequest request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        DataTreeModification mod = request.getModification();
        final com.google.common.base.Optional optTicks = com.google.common.base.Optional.of((Object)enqueuedTicks);
        mod.applyToCursor((DataTreeModificationCursor)new AbstractDataTreeModificationCursor(){

            public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                RemoteProxyTransaction.this.appendModification((TransactionModification)new TransactionWrite(this.current().node(child), data), (com.google.common.base.Optional<Long>)optTicks);
            }

            public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                RemoteProxyTransaction.this.appendModification((TransactionModification)new TransactionMerge(this.current().node(child), data), (com.google.common.base.Optional<Long>)optTicks);
            }

            public void delete(YangInstanceIdentifier.PathArgument child) {
                RemoteProxyTransaction.this.appendModification((TransactionModification)new TransactionDelete(this.current().node(child)), (com.google.common.base.Optional<Long>)optTicks);
            }
        });
        this.enqueueRequest((TransactionRequest<?>)this.commitRequest(request.isCoordinated()), callback, enqueuedTicks);
    }

    @Override
    void handleReplayedRemoteRequest(TransactionRequest<?> request, @Nullable Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        Consumer<Response<?, ?>> cb = callback != null ? callback : resp -> {};
        com.google.common.base.Optional optTicks = com.google.common.base.Optional.of((Object)enqueuedTicks);
        if (request instanceof ModifyTransactionRequest) {
            this.handleReplayedModifyTransactionRequest(enqueuedTicks, cb, (ModifyTransactionRequest)request);
        } else if (request instanceof ReadTransactionRequest) {
            this.ensureFlushedBuider((com.google.common.base.Optional<Long>)optTicks);
            this.enqueueRequest((TransactionRequest<?>)new ReadTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), ((ReadTransactionRequest)request).getPath(), this.isSnapshotOnly()), resp -> {
                this.recordFinishedRequest((Response<?, ?>)resp);
                cb.accept((Response<?, ?>)resp);
            }, enqueuedTicks);
        } else if (request instanceof ExistsTransactionRequest) {
            this.ensureFlushedBuider((com.google.common.base.Optional<Long>)optTicks);
            this.enqueueRequest((TransactionRequest<?>)new ExistsTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), ((ExistsTransactionRequest)request).getPath(), this.isSnapshotOnly()), resp -> {
                this.recordFinishedRequest((Response<?, ?>)resp);
                cb.accept((Response<?, ?>)resp);
            }, enqueuedTicks);
        } else if (request instanceof TransactionPreCommitRequest) {
            this.ensureFlushedBuider((com.google.common.base.Optional<Long>)optTicks);
            TransactionPreCommitRequest tmp = new TransactionPreCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor());
            this.enqueueRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleReplayedRemoteRequest$14((TransactionRequest)tmp, cb, arg_0), enqueuedTicks);
        } else if (request instanceof TransactionDoCommitRequest) {
            this.ensureFlushedBuider((com.google.common.base.Optional<Long>)optTicks);
            this.enqueueRequest((TransactionRequest<?>)new TransactionDoCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback, enqueuedTicks);
        } else if (request instanceof TransactionAbortRequest) {
            this.ensureFlushedBuider((com.google.common.base.Optional<Long>)optTicks);
            this.enqueueDoAbort(callback, enqueuedTicks);
        } else if (request instanceof TransactionPurgeRequest) {
            this.enqueuePurge(callback, enqueuedTicks);
        } else if (request instanceof IncrementTransactionSequenceRequest) {
            IncrementTransactionSequenceRequest req = (IncrementTransactionSequenceRequest)request;
            this.ensureFlushedBuider((com.google.common.base.Optional<Long>)optTicks);
            this.enqueueRequest((TransactionRequest<?>)new IncrementTransactionSequenceRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), this.snapshotOnly, req.getIncrement()), callback, enqueuedTicks);
            this.incrementSequence(req.getIncrement());
        } else {
            throw new IllegalArgumentException("Unhandled request {}" + request);
        }
    }

    private void handleReplayedModifyTransactionRequest(long enqueuedTicks, Consumer<Response<?, ?>> cb, ModifyTransactionRequest req) {
        req.getModifications().forEach(this::appendModification);
        Optional maybeProto = req.getPersistenceProtocol();
        if (maybeProto.isPresent()) {
            if (this.markSealed()) {
                this.sealOnly();
            }
            switch ((PersistenceProtocol)maybeProto.get()) {
                case ABORT: {
                    ModifyTransactionRequest tmp = this.abortRequest();
                    this.enqueueRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleReplayedModifyTransactionRequest$15((TransactionRequest)tmp, cb, arg_0), enqueuedTicks);
                    break;
                }
                case SIMPLE: {
                    ModifyTransactionRequest tmp = this.commitRequest(false);
                    this.enqueueRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleReplayedModifyTransactionRequest$16((TransactionRequest)tmp, cb, arg_0), enqueuedTicks);
                    break;
                }
                case THREE_PHASE: {
                    ModifyTransactionRequest tmp = this.commitRequest(true);
                    this.enqueueRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleReplayedModifyTransactionRequest$17((TransactionRequest)tmp, cb, arg_0), enqueuedTicks);
                    break;
                }
                case READY: {
                    ModifyTransactionRequest tmp = this.readyRequest();
                    this.enqueueRequest((TransactionRequest<?>)tmp, arg_0 -> this.lambda$handleReplayedModifyTransactionRequest$18((TransactionRequest)tmp, cb, arg_0), enqueuedTicks);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled protocol " + maybeProto.get());
                }
            }
        }
    }

    private /* synthetic */ void lambda$handleReplayedModifyTransactionRequest$18(TransactionRequest tmp, Consumer cb, Response resp) {
        this.recordSuccessfulRequest(tmp);
        cb.accept(resp);
    }

    private /* synthetic */ void lambda$handleReplayedModifyTransactionRequest$17(TransactionRequest tmp, Consumer cb, Response resp) {
        this.recordSuccessfulRequest(tmp);
        cb.accept(resp);
    }

    private /* synthetic */ void lambda$handleReplayedModifyTransactionRequest$16(TransactionRequest tmp, Consumer cb, Response resp) {
        this.completeModify(tmp, resp);
        cb.accept(resp);
    }

    private /* synthetic */ void lambda$handleReplayedModifyTransactionRequest$15(TransactionRequest tmp, Consumer cb, Response resp) {
        this.completeModify(tmp, resp);
        cb.accept(resp);
    }

    private /* synthetic */ void lambda$handleReplayedRemoteRequest$14(TransactionRequest tmp, Consumer cb, Response resp) {
        this.recordSuccessfulRequest(tmp);
        cb.accept(resp);
    }

    private /* synthetic */ void lambda$handleForwardedModifyTransactionRequest$10(TransactionRequest tmp, Consumer callback, Response resp) {
        this.recordSuccessfulRequest(tmp);
        callback.accept(resp);
    }

    private /* synthetic */ void lambda$handleForwardedModifyTransactionRequest$9(TransactionRequest tmp, Consumer callback, Response resp) {
        this.recordSuccessfulRequest(tmp);
        callback.accept(resp);
    }

    private /* synthetic */ void lambda$handleForwardedModifyTransactionRequest$8(TransactionRequest tmp, Consumer callback, Response resp) {
        this.completeModify(tmp, resp);
        callback.accept(resp);
    }

    private /* synthetic */ void lambda$handleForwardedModifyTransactionRequest$7(TransactionRequest tmp, Consumer callback, Response resp) {
        this.completeModify(tmp, resp);
        callback.accept(resp);
    }

    private /* synthetic */ void lambda$handleForwardedRequest$6(TransactionRequest tmp, Consumer callback, Response resp) {
        this.recordSuccessfulRequest(tmp);
        callback.accept(resp);
    }
}

