/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.Props;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.datastore.messages.DataChanged;
import org.opendaylight.controller.cluster.datastore.messages.DataChangedReply;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeListenerInfo;
import org.opendaylight.controller.cluster.datastore.messages.EnableNotification;
import org.opendaylight.controller.cluster.datastore.messages.GetInfo;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Deprecated
public class DataChangeListener
extends AbstractUntypedActor {
    private final AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener;
    private final YangInstanceIdentifier registeredPath;
    private boolean notificationsEnabled = false;
    private long notificationCount;

    public DataChangeListener(AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener, YangInstanceIdentifier registeredPath) {
        this.listener = (AsyncDataChangeListener)Preconditions.checkNotNull(listener, (Object)"listener should not be null");
        this.registeredPath = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)registeredPath);
    }

    public void handleReceive(Object message) {
        if (message instanceof DataChanged) {
            this.dataChanged(message);
        } else if (message instanceof EnableNotification) {
            this.enableNotification((EnableNotification)message);
        } else if (message instanceof GetInfo) {
            this.getSender().tell((Object)new DataTreeListenerInfo(this.listener.toString(), this.registeredPath.toString(), this.notificationsEnabled, this.notificationCount), this.getSelf());
        } else {
            this.unknownMessage(message);
        }
    }

    private void enableNotification(EnableNotification message) {
        this.notificationsEnabled = message.isEnabled();
        this.LOG.debug("{} notifications for listener {}", (Object)(this.notificationsEnabled ? "Enabled" : "Disabled"), this.listener);
    }

    private void dataChanged(Object message) {
        if (!this.notificationsEnabled) {
            this.LOG.debug("Notifications not enabled for listener {} - dropping change notification", this.listener);
            return;
        }
        DataChanged reply = (DataChanged)message;
        AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> change = reply.getChange();
        this.LOG.debug("Sending change notification {} to listener {}", change, this.listener);
        ++this.notificationCount;
        try {
            this.listener.onDataChanged(change);
        }
        catch (RuntimeException e) {
            this.LOG.error(String.format("Error notifying listener %s", this.listener), (Throwable)e);
        }
        if (this.isValidSender(this.getSender())) {
            this.getSender().tell((Object)DataChangedReply.INSTANCE, this.getSelf());
        }
    }

    public static Props props(AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener, YangInstanceIdentifier registeredPath) {
        return Props.create(DataChangeListener.class, (Object[])new Object[]{listener, registeredPath});
    }
}

