/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.datastore.messages.DataChanged;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DataChangeListenerProxy
implements AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> {
    private final ActorSelection dataChangeListenerActor;

    public DataChangeListenerProxy(ActorSelection dataChangeListenerActor) {
        this.dataChangeListenerActor = (ActorSelection)Preconditions.checkNotNull((Object)dataChangeListenerActor, (Object)"dataChangeListenerActor should not be null");
    }

    public void onDataChanged(AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> change) {
        this.dataChangeListenerActor.tell((Object)new DataChanged(change), ActorRef.noSender());
    }
}

