/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import org.opendaylight.controller.cluster.datastore.AbstractDataListenerSupport;
import org.opendaylight.controller.cluster.datastore.DataChangeListenerProxy;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.actors.DataTreeNotificationListenerRegistrationActor;
import org.opendaylight.controller.cluster.datastore.messages.RegisterChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class DataChangeListenerSupport
extends AbstractDataListenerSupport<AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>, RegisterChangeListener> {
    DataChangeListenerSupport(Shard shard) {
        super(shard);
    }

    @Override
    void doRegistration(RegisterChangeListener message, ActorRef registrationActor) {
        ActorSelection listenerActor = this.processListenerRegistrationMessage(message);
        DataChangeListenerProxy listener = new DataChangeListenerProxy(listenerActor);
        this.log().debug("{}: Registering for path {}", (Object)this.persistenceId(), (Object)message.getPath());
        ShardDataTree shardDataTree = this.getShard().getDataStore();
        shardDataTree.registerDataChangeListener(message.getPath(), listener, message.getScope(), shardDataTree.readCurrentData(), registration -> registrationActor.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration((ListenerRegistration<?>)registration, () -> this.removeListenerActor(listenerActor)), ActorRef.noSender()));
    }

    @Override
    protected String logName() {
        return "registerDataChangeListener";
    }
}

