/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import org.opendaylight.controller.cluster.datastore.AbstractDataListenerSupport;
import org.opendaylight.controller.cluster.datastore.ForwardingDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.actors.DataTreeNotificationListenerRegistrationActor;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

final class DataTreeChangeListenerSupport
extends AbstractDataListenerSupport<DOMDataTreeChangeListener, RegisterDataTreeChangeListener> {
    DataTreeChangeListenerSupport(Shard shard) {
        super(shard);
    }

    @Override
    void doRegistration(RegisterDataTreeChangeListener message, ActorRef registrationActor) {
        ActorSelection listenerActor = this.processListenerRegistrationMessage(message);
        ForwardingDataTreeChangeListener listener = new ForwardingDataTreeChangeListener(listenerActor);
        this.log().debug("{}: Registering listenerActor {} for path {}", new Object[]{this.persistenceId(), listenerActor, message.getPath()});
        ShardDataTree shardDataTree = this.getShard().getDataStore();
        shardDataTree.registerTreeChangeListener(message.getPath(), listener, shardDataTree.readCurrentData(), registration -> registrationActor.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration((ListenerRegistration<?>)registration, () -> this.removeListenerActor(listenerActor)), ActorRef.noSender()));
    }

    @Override
    protected String logName() {
        return "registerTreeChangeListener";
    }
}

