/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.text.WordUtils;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.common.actor.AkkaConfigurationReader;
import org.opendaylight.controller.cluster.common.actor.FileAkkaConfigurationReader;
import org.opendaylight.controller.cluster.raft.ConfigParams;
import org.opendaylight.controller.cluster.raft.DefaultConfigParamsImpl;
import org.opendaylight.controller.cluster.raft.PeerAddressResolver;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMDataStoreConfigProperties;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class DatastoreContext
implements ClientActorConfig {
    public static final String METRICS_DOMAIN = "org.opendaylight.controller.cluster.datastore";
    public static final Duration DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT = Duration.create((long)10L, (TimeUnit)TimeUnit.MINUTES);
    public static final int DEFAULT_OPERATION_TIMEOUT_IN_MS = 5000;
    public static final int DEFAULT_SHARD_TX_COMMIT_TIMEOUT_IN_SECONDS = 30;
    public static final int DEFAULT_JOURNAL_RECOVERY_BATCH_SIZE = 1;
    public static final int DEFAULT_SNAPSHOT_BATCH_COUNT = 20000;
    public static final int DEFAULT_HEARTBEAT_INTERVAL_IN_MILLIS = 500;
    public static final int DEFAULT_ISOLATED_LEADER_CHECK_INTERVAL_IN_MILLIS = 5000;
    public static final int DEFAULT_SHARD_TX_COMMIT_QUEUE_CAPACITY = 50000;
    public static final Timeout DEFAULT_SHARD_INITIALIZATION_TIMEOUT = new Timeout(5L, TimeUnit.MINUTES);
    public static final Timeout DEFAULT_SHARD_LEADER_ELECTION_TIMEOUT = new Timeout(30L, TimeUnit.SECONDS);
    public static final boolean DEFAULT_PERSISTENT = true;
    public static final FileAkkaConfigurationReader DEFAULT_CONFIGURATION_READER = new FileAkkaConfigurationReader();
    public static final int DEFAULT_SHARD_SNAPSHOT_DATA_THRESHOLD_PERCENTAGE = 12;
    public static final int DEFAULT_SHARD_ELECTION_TIMEOUT_FACTOR = 2;
    public static final int DEFAULT_TX_CREATION_INITIAL_RATE_LIMIT = 100;
    public static final String UNKNOWN_DATA_STORE_TYPE = "unknown";
    public static final int DEFAULT_SHARD_BATCHED_MODIFICATION_COUNT = 1000;
    public static final long DEFAULT_SHARD_COMMIT_QUEUE_EXPIRY_TIMEOUT_IN_MS = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
    public static final int DEFAULT_MAX_MESSAGE_SLICE_SIZE = 2048000;
    public static final long DEFAULT_SYNC_INDEX_THRESHOLD = 10L;
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreContext.class);
    private static final Set<String> GLOBAL_DATASTORE_NAMES = ConcurrentHashMap.newKeySet();
    private final DefaultConfigParamsImpl raftConfig = new DefaultConfigParamsImpl();
    private InMemoryDOMDataStoreConfigProperties dataStoreProperties;
    private Duration shardTransactionIdleTimeout = DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT;
    private long operationTimeoutInMillis = 5000L;
    private String dataStoreMXBeanType;
    private int shardTransactionCommitTimeoutInSeconds = 30;
    private int shardTransactionCommitQueueCapacity = 50000;
    private Timeout shardInitializationTimeout = DEFAULT_SHARD_INITIALIZATION_TIMEOUT;
    private Timeout shardLeaderElectionTimeout = DEFAULT_SHARD_LEADER_ELECTION_TIMEOUT;
    private boolean persistent = true;
    private AkkaConfigurationReader configurationReader = DEFAULT_CONFIGURATION_READER;
    private long transactionCreationInitialRateLimit = 100L;
    private String dataStoreName = "unknown";
    private LogicalDatastoreType logicalStoreType = LogicalDatastoreType.OPERATIONAL;
    private YangInstanceIdentifier storeRoot = YangInstanceIdentifier.EMPTY;
    private int shardBatchedModificationCount = 1000;
    private boolean writeOnlyTransactionOptimizationsEnabled = true;
    private long shardCommitQueueExpiryTimeoutInMillis = DEFAULT_SHARD_COMMIT_QUEUE_EXPIRY_TIMEOUT_IN_MS;
    private boolean useTellBasedProtocol = false;
    private boolean transactionDebugContextEnabled = false;
    private String shardManagerPersistenceId;
    private int maximumMessageSliceSize = 2048000;
    private long backendAlivenessTimerInterval = AbstractClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS;
    private long requestTimeout = AbstractClientConnection.DEFAULT_REQUEST_TIMEOUT_NANOS;
    private long noProgressTimeout = AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS;

    public static Set<String> getGlobalDatastoreNames() {
        return GLOBAL_DATASTORE_NAMES;
    }

    DatastoreContext() {
        this.setShardJournalRecoveryLogBatchSize(1);
        this.setSnapshotBatchCount(20000L);
        this.setHeartbeatInterval(500L);
        this.setIsolatedLeaderCheckInterval(5000L);
        this.setSnapshotDataThresholdPercentage(12);
        this.setElectionTimeoutFactor(2L);
        this.setSyncIndexThreshold(10L);
        this.setMaximumMessageSliceSize(2048000);
    }

    private DatastoreContext(DatastoreContext other) {
        this.dataStoreProperties = other.dataStoreProperties;
        this.shardTransactionIdleTimeout = other.shardTransactionIdleTimeout;
        this.operationTimeoutInMillis = other.operationTimeoutInMillis;
        this.dataStoreMXBeanType = other.dataStoreMXBeanType;
        this.shardTransactionCommitTimeoutInSeconds = other.shardTransactionCommitTimeoutInSeconds;
        this.shardTransactionCommitQueueCapacity = other.shardTransactionCommitQueueCapacity;
        this.shardInitializationTimeout = other.shardInitializationTimeout;
        this.shardLeaderElectionTimeout = other.shardLeaderElectionTimeout;
        this.persistent = other.persistent;
        this.configurationReader = other.configurationReader;
        this.transactionCreationInitialRateLimit = other.transactionCreationInitialRateLimit;
        this.dataStoreName = other.dataStoreName;
        this.logicalStoreType = other.logicalStoreType;
        this.storeRoot = other.storeRoot;
        this.shardBatchedModificationCount = other.shardBatchedModificationCount;
        this.writeOnlyTransactionOptimizationsEnabled = other.writeOnlyTransactionOptimizationsEnabled;
        this.shardCommitQueueExpiryTimeoutInMillis = other.shardCommitQueueExpiryTimeoutInMillis;
        this.transactionDebugContextEnabled = other.transactionDebugContextEnabled;
        this.shardManagerPersistenceId = other.shardManagerPersistenceId;
        this.useTellBasedProtocol = other.useTellBasedProtocol;
        this.backendAlivenessTimerInterval = other.backendAlivenessTimerInterval;
        this.requestTimeout = other.requestTimeout;
        this.noProgressTimeout = other.noProgressTimeout;
        this.setShardJournalRecoveryLogBatchSize(other.raftConfig.getJournalRecoveryLogBatchSize());
        this.setSnapshotBatchCount(other.raftConfig.getSnapshotBatchCount());
        this.setHeartbeatInterval(other.raftConfig.getHeartBeatInterval().toMillis());
        this.setIsolatedLeaderCheckInterval(other.raftConfig.getIsolatedCheckIntervalInMillis());
        this.setSnapshotDataThresholdPercentage(other.raftConfig.getSnapshotDataThresholdPercentage());
        this.setElectionTimeoutFactor(other.raftConfig.getElectionTimeoutFactor());
        this.setCustomRaftPolicyImplementation(other.raftConfig.getCustomRaftPolicyImplementationClass());
        this.setMaximumMessageSliceSize(other.getMaximumMessageSliceSize());
        this.setShardSnapshotChunkSize(other.raftConfig.getSnapshotChunkSize());
        this.setPeerAddressResolver(other.raftConfig.getPeerAddressResolver());
        this.setTempFileDirectory(other.getTempFileDirectory());
        this.setFileBackedStreamingThreshold(other.getFileBackedStreamingThreshold());
        this.setSyncIndexThreshold(other.raftConfig.getSyncIndexThreshold());
    }

    public static Builder newBuilder() {
        return new Builder(new DatastoreContext());
    }

    public static Builder newBuilderFrom(DatastoreContext context) {
        return new Builder(new DatastoreContext(context));
    }

    public InMemoryDOMDataStoreConfigProperties getDataStoreProperties() {
        return this.dataStoreProperties;
    }

    public Duration getShardTransactionIdleTimeout() {
        return this.shardTransactionIdleTimeout;
    }

    public String getDataStoreMXBeanType() {
        return this.dataStoreMXBeanType;
    }

    public long getOperationTimeoutInMillis() {
        return this.operationTimeoutInMillis;
    }

    public ConfigParams getShardRaftConfig() {
        return this.raftConfig;
    }

    public int getShardTransactionCommitTimeoutInSeconds() {
        return this.shardTransactionCommitTimeoutInSeconds;
    }

    public int getShardTransactionCommitQueueCapacity() {
        return this.shardTransactionCommitQueueCapacity;
    }

    public Timeout getShardInitializationTimeout() {
        return this.shardInitializationTimeout;
    }

    public Timeout getShardLeaderElectionTimeout() {
        return this.shardLeaderElectionTimeout;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public AkkaConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public long getShardElectionTimeoutFactor() {
        return this.raftConfig.getElectionTimeoutFactor();
    }

    public String getDataStoreName() {
        return this.dataStoreName;
    }

    public LogicalDatastoreType getLogicalStoreType() {
        return this.logicalStoreType;
    }

    public YangInstanceIdentifier getStoreRoot() {
        return this.storeRoot;
    }

    public long getTransactionCreationInitialRateLimit() {
        return this.transactionCreationInitialRateLimit;
    }

    public String getShardManagerPersistenceId() {
        return this.shardManagerPersistenceId;
    }

    public String getTempFileDirectory() {
        return this.raftConfig.getTempFileDirectory();
    }

    private void setTempFileDirectory(String tempFileDirectory) {
        this.raftConfig.setTempFileDirectory(tempFileDirectory);
    }

    public int getFileBackedStreamingThreshold() {
        return this.raftConfig.getFileBackedStreamingThreshold();
    }

    private void setFileBackedStreamingThreshold(int fileBackedStreamingThreshold) {
        this.raftConfig.setFileBackedStreamingThreshold(fileBackedStreamingThreshold);
    }

    private void setPeerAddressResolver(PeerAddressResolver resolver) {
        this.raftConfig.setPeerAddressResolver(resolver);
    }

    private void setHeartbeatInterval(long shardHeartbeatIntervalInMillis) {
        this.raftConfig.setHeartBeatInterval(new FiniteDuration(shardHeartbeatIntervalInMillis, TimeUnit.MILLISECONDS));
    }

    private void setShardJournalRecoveryLogBatchSize(int shardJournalRecoveryLogBatchSize) {
        this.raftConfig.setJournalRecoveryLogBatchSize(shardJournalRecoveryLogBatchSize);
    }

    private void setIsolatedLeaderCheckInterval(long shardIsolatedLeaderCheckIntervalInMillis) {
        this.raftConfig.setIsolatedLeaderCheckInterval(new FiniteDuration(shardIsolatedLeaderCheckIntervalInMillis, TimeUnit.MILLISECONDS));
    }

    private void setElectionTimeoutFactor(long shardElectionTimeoutFactor) {
        this.raftConfig.setElectionTimeoutFactor(shardElectionTimeoutFactor);
    }

    private void setCustomRaftPolicyImplementation(String customRaftPolicyImplementation) {
        this.raftConfig.setCustomRaftPolicyImplementationClass(customRaftPolicyImplementation);
    }

    private void setSnapshotDataThresholdPercentage(int shardSnapshotDataThresholdPercentage) {
        Preconditions.checkArgument((shardSnapshotDataThresholdPercentage >= 0 && shardSnapshotDataThresholdPercentage <= 100 ? 1 : 0) != 0);
        this.raftConfig.setSnapshotDataThresholdPercentage(shardSnapshotDataThresholdPercentage);
    }

    private void setSnapshotBatchCount(long shardSnapshotBatchCount) {
        this.raftConfig.setSnapshotBatchCount(shardSnapshotBatchCount);
    }

    @Deprecated
    private void setShardSnapshotChunkSize(int shardSnapshotChunkSize) {
        if (shardSnapshotChunkSize < this.maximumMessageSliceSize) {
            this.raftConfig.setSnapshotChunkSize(shardSnapshotChunkSize);
        }
    }

    private void setMaximumMessageSliceSize(int maximumMessageSliceSize) {
        this.raftConfig.setSnapshotChunkSize(maximumMessageSliceSize);
        this.maximumMessageSliceSize = maximumMessageSliceSize;
    }

    private void setSyncIndexThreshold(long syncIndexThreshold) {
        this.raftConfig.setSyncIndexThreshold(syncIndexThreshold);
    }

    public int getShardBatchedModificationCount() {
        return this.shardBatchedModificationCount;
    }

    public boolean isWriteOnlyTransactionOptimizationsEnabled() {
        return this.writeOnlyTransactionOptimizationsEnabled;
    }

    public long getShardCommitQueueExpiryTimeoutInMillis() {
        return this.shardCommitQueueExpiryTimeoutInMillis;
    }

    public boolean isTransactionDebugContextEnabled() {
        return this.transactionDebugContextEnabled;
    }

    public boolean isUseTellBasedProtocol() {
        return this.useTellBasedProtocol;
    }

    public int getMaximumMessageSliceSize() {
        return this.maximumMessageSliceSize;
    }

    public long getBackendAlivenessTimerInterval() {
        return this.backendAlivenessTimerInterval;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getNoProgressTimeout() {
        return this.noProgressTimeout;
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<DatastoreContext> {
        private final DatastoreContext datastoreContext;
        private int maxShardDataChangeExecutorPoolSize = 20;
        private int maxShardDataChangeExecutorQueueSize = 1000;
        private int maxShardDataChangeListenerQueueSize = 1000;
        private int maxShardDataStoreExecutorQueueSize = 5000;

        Builder(DatastoreContext datastoreContext) {
            this.datastoreContext = datastoreContext;
            if (datastoreContext.getDataStoreProperties() != null) {
                this.maxShardDataChangeExecutorPoolSize = datastoreContext.getDataStoreProperties().getMaxDataChangeExecutorPoolSize();
                this.maxShardDataChangeExecutorQueueSize = datastoreContext.getDataStoreProperties().getMaxDataChangeExecutorQueueSize();
                this.maxShardDataChangeListenerQueueSize = datastoreContext.getDataStoreProperties().getMaxDataChangeListenerQueueSize();
                this.maxShardDataStoreExecutorQueueSize = datastoreContext.getDataStoreProperties().getMaxDataStoreExecutorQueueSize();
            }
        }

        public Builder boundedMailboxCapacity(int boundedMailboxCapacity) {
            return this;
        }

        public Builder enableMetricCapture(boolean enableMetricCapture) {
            return this;
        }

        public Builder shardTransactionIdleTimeout(long timeout, TimeUnit unit) {
            this.datastoreContext.shardTransactionIdleTimeout = (Duration)Duration.create((long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder shardTransactionIdleTimeoutInMinutes(long timeout) {
            return this.shardTransactionIdleTimeout(timeout, TimeUnit.MINUTES);
        }

        public Builder operationTimeoutInSeconds(int operationTimeoutInSeconds) {
            this.datastoreContext.operationTimeoutInMillis = TimeUnit.SECONDS.toMillis(operationTimeoutInSeconds);
            return this;
        }

        public Builder operationTimeoutInMillis(long operationTimeoutInMillis) {
            this.datastoreContext.operationTimeoutInMillis = operationTimeoutInMillis;
            return this;
        }

        public Builder dataStoreMXBeanType(String dataStoreMXBeanType) {
            this.datastoreContext.dataStoreMXBeanType = dataStoreMXBeanType;
            return this;
        }

        public Builder shardTransactionCommitTimeoutInSeconds(int shardTransactionCommitTimeoutInSeconds) {
            this.datastoreContext.shardTransactionCommitTimeoutInSeconds = shardTransactionCommitTimeoutInSeconds;
            return this;
        }

        public Builder shardJournalRecoveryLogBatchSize(int shardJournalRecoveryLogBatchSize) {
            this.datastoreContext.setShardJournalRecoveryLogBatchSize(shardJournalRecoveryLogBatchSize);
            return this;
        }

        public Builder shardSnapshotBatchCount(int shardSnapshotBatchCount) {
            this.datastoreContext.setSnapshotBatchCount(shardSnapshotBatchCount);
            return this;
        }

        public Builder shardSnapshotDataThresholdPercentage(int shardSnapshotDataThresholdPercentage) {
            this.datastoreContext.setSnapshotDataThresholdPercentage(shardSnapshotDataThresholdPercentage);
            return this;
        }

        public Builder shardHeartbeatIntervalInMillis(int shardHeartbeatIntervalInMillis) {
            this.datastoreContext.setHeartbeatInterval(shardHeartbeatIntervalInMillis);
            return this;
        }

        public Builder shardTransactionCommitQueueCapacity(int shardTransactionCommitQueueCapacity) {
            this.datastoreContext.shardTransactionCommitQueueCapacity = shardTransactionCommitQueueCapacity;
            return this;
        }

        public Builder shardInitializationTimeout(long timeout, TimeUnit unit) {
            this.datastoreContext.shardInitializationTimeout = new Timeout(timeout, unit);
            return this;
        }

        public Builder shardInitializationTimeoutInSeconds(long timeout) {
            return this.shardInitializationTimeout(timeout, TimeUnit.SECONDS);
        }

        public Builder shardLeaderElectionTimeout(long timeout, TimeUnit unit) {
            this.datastoreContext.shardLeaderElectionTimeout = new Timeout(timeout, unit);
            return this;
        }

        public Builder shardLeaderElectionTimeoutInSeconds(long timeout) {
            return this.shardLeaderElectionTimeout(timeout, TimeUnit.SECONDS);
        }

        public Builder configurationReader(AkkaConfigurationReader configurationReader) {
            this.datastoreContext.configurationReader = configurationReader;
            return this;
        }

        public Builder persistent(boolean persistent) {
            this.datastoreContext.persistent = persistent;
            return this;
        }

        public Builder shardIsolatedLeaderCheckIntervalInMillis(int shardIsolatedLeaderCheckIntervalInMillis) {
            this.datastoreContext.setIsolatedLeaderCheckInterval(shardIsolatedLeaderCheckIntervalInMillis);
            return this;
        }

        public Builder shardElectionTimeoutFactor(long shardElectionTimeoutFactor) {
            this.datastoreContext.setElectionTimeoutFactor(shardElectionTimeoutFactor);
            return this;
        }

        public Builder transactionCreationInitialRateLimit(long initialRateLimit) {
            this.datastoreContext.transactionCreationInitialRateLimit = initialRateLimit;
            return this;
        }

        public Builder logicalStoreType(LogicalDatastoreType logicalStoreType) {
            this.datastoreContext.logicalStoreType = (LogicalDatastoreType)Preconditions.checkNotNull((Object)logicalStoreType);
            switch (logicalStoreType) {
                case CONFIGURATION: {
                    this.dataStoreName("config");
                    break;
                }
                case OPERATIONAL: {
                    this.dataStoreName("operational");
                    break;
                }
                default: {
                    this.dataStoreName(logicalStoreType.name());
                }
            }
            return this;
        }

        public Builder storeRoot(YangInstanceIdentifier storeRoot) {
            this.datastoreContext.storeRoot = storeRoot;
            return this;
        }

        public Builder dataStoreName(String dataStoreName) {
            this.datastoreContext.dataStoreName = (String)Preconditions.checkNotNull((Object)dataStoreName);
            this.datastoreContext.dataStoreMXBeanType = "Distributed" + WordUtils.capitalize((String)dataStoreName) + "Datastore";
            return this;
        }

        public Builder shardBatchedModificationCount(int shardBatchedModificationCount) {
            this.datastoreContext.shardBatchedModificationCount = shardBatchedModificationCount;
            return this;
        }

        public Builder writeOnlyTransactionOptimizationsEnabled(boolean value) {
            this.datastoreContext.writeOnlyTransactionOptimizationsEnabled = value;
            return this;
        }

        public Builder shardCommitQueueExpiryTimeoutInMillis(long value) {
            this.datastoreContext.shardCommitQueueExpiryTimeoutInMillis = value;
            return this;
        }

        public Builder shardCommitQueueExpiryTimeoutInSeconds(long value) {
            this.datastoreContext.shardCommitQueueExpiryTimeoutInMillis = TimeUnit.MILLISECONDS.convert(value, TimeUnit.SECONDS);
            return this;
        }

        public Builder transactionDebugContextEnabled(boolean value) {
            this.datastoreContext.transactionDebugContextEnabled = value;
            return this;
        }

        public Builder maxShardDataChangeExecutorPoolSize(int newMaxShardDataChangeExecutorPoolSize) {
            this.maxShardDataChangeExecutorPoolSize = newMaxShardDataChangeExecutorPoolSize;
            return this;
        }

        public Builder maxShardDataChangeExecutorQueueSize(int newMaxShardDataChangeExecutorQueueSize) {
            this.maxShardDataChangeExecutorQueueSize = newMaxShardDataChangeExecutorQueueSize;
            return this;
        }

        public Builder maxShardDataChangeListenerQueueSize(int newMaxShardDataChangeListenerQueueSize) {
            this.maxShardDataChangeListenerQueueSize = newMaxShardDataChangeListenerQueueSize;
            return this;
        }

        public Builder maxShardDataStoreExecutorQueueSize(int newMaxShardDataStoreExecutorQueueSize) {
            this.maxShardDataStoreExecutorQueueSize = newMaxShardDataStoreExecutorQueueSize;
            return this;
        }

        public Builder useTellBasedProtocol(boolean value) {
            this.datastoreContext.useTellBasedProtocol = value;
            return this;
        }

        @VisibleForTesting
        public Builder shardManagerPersistenceId(String id) {
            this.datastoreContext.shardManagerPersistenceId = id;
            return this;
        }

        public Builder customRaftPolicyImplementation(String customRaftPolicyImplementation) {
            this.datastoreContext.setCustomRaftPolicyImplementation(customRaftPolicyImplementation);
            return this;
        }

        @Deprecated
        public Builder shardSnapshotChunkSize(int shardSnapshotChunkSize) {
            LOG.warn("The shard-snapshot-chunk-size configuration parameter is deprecated - use maximum-message-slice-size instead");
            this.datastoreContext.setShardSnapshotChunkSize(shardSnapshotChunkSize);
            return this;
        }

        public Builder maximumMessageSliceSize(int maximumMessageSliceSize) {
            this.datastoreContext.setMaximumMessageSliceSize(maximumMessageSliceSize);
            return this;
        }

        public Builder shardPeerAddressResolver(PeerAddressResolver resolver) {
            this.datastoreContext.setPeerAddressResolver(resolver);
            return this;
        }

        public Builder tempFileDirectory(String tempFileDirectory) {
            this.datastoreContext.setTempFileDirectory(tempFileDirectory);
            return this;
        }

        public Builder fileBackedStreamingThresholdInMegabytes(int fileBackedStreamingThreshold) {
            this.datastoreContext.setFileBackedStreamingThreshold(fileBackedStreamingThreshold * 0x100000);
            return this;
        }

        public Builder syncIndexThreshold(long syncIndexThreshold) {
            this.datastoreContext.setSyncIndexThreshold(syncIndexThreshold);
            return this;
        }

        public Builder backendAlivenessTimerIntervalInSeconds(long interval) {
            this.datastoreContext.backendAlivenessTimerInterval = TimeUnit.SECONDS.toNanos(interval);
            return this;
        }

        public Builder frontendRequestTimeoutInSeconds(long timeout) {
            this.datastoreContext.requestTimeout = TimeUnit.SECONDS.toNanos(timeout);
            return this;
        }

        public Builder frontendNoProgressTimeoutInSeconds(long timeout) {
            this.datastoreContext.noProgressTimeout = TimeUnit.SECONDS.toNanos(timeout);
            return this;
        }

        public DatastoreContext build() {
            this.datastoreContext.dataStoreProperties = InMemoryDOMDataStoreConfigProperties.create((int)this.maxShardDataChangeExecutorPoolSize, (int)this.maxShardDataChangeExecutorQueueSize, (int)this.maxShardDataChangeListenerQueueSize, (int)this.maxShardDataStoreExecutorQueueSize);
            if (this.datastoreContext.dataStoreName != null) {
                GLOBAL_DATASTORE_NAMES.add(this.datastoreContext.dataStoreName);
            }
            return this.datastoreContext;
        }
    }
}

