/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendHistoryMetadataBuilder;
import org.opendaylight.controller.cluster.datastore.LeaderFrontendState;
import org.opendaylight.controller.cluster.datastore.LocalFrontendHistory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.StandaloneFrontendHistory;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongRangeSet;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class FrontendClientMetadataBuilder
implements Builder<FrontendClientMetadata>,
Identifiable<ClientIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendClientMetadataBuilder.class);
    private final Map<LocalHistoryIdentifier, FrontendHistoryMetadataBuilder> currentHistories = new HashMap<LocalHistoryIdentifier, FrontendHistoryMetadataBuilder>();
    private final UnsignedLongRangeSet purgedHistories;
    private final ClientIdentifier identifier;
    private final String shardName;

    FrontendClientMetadataBuilder(String shardName, ClientIdentifier identifier) {
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName);
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.purgedHistories = UnsignedLongRangeSet.create();
        LocalHistoryIdentifier standaloneId = this.standaloneHistoryId();
        this.currentHistories.put(standaloneId, new FrontendHistoryMetadataBuilder(standaloneId));
    }

    FrontendClientMetadataBuilder(String shardName, FrontendClientMetadata meta) {
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName);
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)meta.getIdentifier());
        this.purgedHistories = UnsignedLongRangeSet.create(meta.getPurgedHistories());
        for (FrontendHistoryMetadata h : meta.getCurrentHistories()) {
            FrontendHistoryMetadataBuilder b = new FrontendHistoryMetadataBuilder(this.identifier, h);
            this.currentHistories.put(b.getIdentifier(), b);
        }
        LocalHistoryIdentifier standaloneId = this.standaloneHistoryId();
        if (!this.currentHistories.containsKey(standaloneId)) {
            LOG.warn("{}: Client {} recovered histories {} do not contain stand-alone history, attempting recovery", new Object[]{shardName, this.identifier, this.currentHistories});
            this.currentHistories.put(standaloneId, new FrontendHistoryMetadataBuilder(standaloneId));
        }
    }

    private LocalHistoryIdentifier standaloneHistoryId() {
        return new LocalHistoryIdentifier(this.identifier, 0L);
    }

    public FrontendClientMetadata build() {
        return new FrontendClientMetadata(this.identifier, this.purgedHistories.toImmutable(), Collections2.transform(this.currentHistories.values(), FrontendHistoryMetadataBuilder::build));
    }

    public ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    void onHistoryCreated(LocalHistoryIdentifier historyId) {
        FrontendHistoryMetadataBuilder newMeta = new FrontendHistoryMetadataBuilder(historyId);
        FrontendHistoryMetadataBuilder oldMeta = this.currentHistories.putIfAbsent(historyId, newMeta);
        if (oldMeta != null) {
            LOG.warn("{}: Reused local history {}", (Object)this.shardName, (Object)historyId);
        } else {
            LOG.debug("{}: Created local history {}", (Object)this.shardName, (Object)historyId);
        }
    }

    void onHistoryClosed(LocalHistoryIdentifier historyId) {
        FrontendHistoryMetadataBuilder builder = this.currentHistories.get(historyId);
        if (builder != null) {
            builder.onHistoryClosed();
            LOG.debug("{}: Closed history {}", (Object)this.shardName, (Object)historyId);
        } else {
            LOG.warn("{}: Closed unknown history {}, ignoring", (Object)this.shardName, (Object)historyId);
        }
    }

    void onHistoryPurged(LocalHistoryIdentifier historyId) {
        FrontendHistoryMetadataBuilder history = this.currentHistories.remove(historyId);
        if (history == null) {
            LOG.warn("{}: Purging unknown history {}", (Object)this.shardName, (Object)historyId);
        }
        this.purgedHistories.add(historyId.getHistoryId());
        LOG.debug("{}: Purged history {}", (Object)historyId);
    }

    void onTransactionAborted(TransactionIdentifier txId) {
        FrontendHistoryMetadataBuilder history = this.getHistory(txId);
        if (history != null) {
            history.onTransactionAborted(txId);
            LOG.debug("{}: Aborted transaction {}", (Object)this.shardName, (Object)txId);
        } else {
            LOG.warn("{}: Unknown history for aborted transaction {}, ignoring", (Object)this.shardName, (Object)txId);
        }
    }

    void onTransactionCommitted(TransactionIdentifier txId) {
        FrontendHistoryMetadataBuilder history = this.getHistory(txId);
        if (history != null) {
            history.onTransactionCommitted(txId);
            LOG.debug("{}: Committed transaction {}", (Object)this.shardName, (Object)txId);
        } else {
            LOG.warn("{}: Unknown history for commited transaction {}, ignoring", (Object)this.shardName, (Object)txId);
        }
    }

    void onTransactionPurged(TransactionIdentifier txId) {
        FrontendHistoryMetadataBuilder history = this.getHistory(txId);
        if (history != null) {
            history.onTransactionPurged(txId);
            LOG.debug("{}: Purged transaction {}", (Object)this.shardName, (Object)txId);
        } else {
            LOG.warn("{}: Unknown history for purged transaction {}, ignoring", (Object)this.shardName, (Object)txId);
        }
    }

    @Nonnull
    LeaderFrontendState toLeaderState(@Nonnull Shard shard) {
        AbstractFrontendHistory singleHistory;
        HashMap<LocalHistoryIdentifier, LocalFrontendHistory> histories = new HashMap<LocalHistoryIdentifier, LocalFrontendHistory>();
        for (FrontendHistoryMetadataBuilder e : this.currentHistories.values()) {
            if (e.getIdentifier().getHistoryId() == 0L) continue;
            AbstractFrontendHistory state = e.toLeaderState(shard);
            Verify.verify((boolean)(state instanceof LocalFrontendHistory));
            histories.put(e.getIdentifier(), (LocalFrontendHistory)state);
        }
        FrontendHistoryMetadataBuilder singleHistoryMeta = this.currentHistories.get(new LocalHistoryIdentifier(this.identifier, 0L));
        if (singleHistoryMeta == null) {
            ShardDataTree tree = shard.getDataStore();
            singleHistory = StandaloneFrontendHistory.create(shard.persistenceId(), this.getIdentifier(), tree);
        } else {
            singleHistory = singleHistoryMeta.toLeaderState(shard);
        }
        return new LeaderFrontendState(shard.persistenceId(), this.getIdentifier(), shard.getDataStore(), this.purgedHistories.copy(), singleHistory, histories);
    }

    private FrontendHistoryMetadataBuilder getHistory(TransactionIdentifier txId) {
        return this.currentHistories.get(txId.getHistoryId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).add("current", this.currentHistories).add("purged", (Object)this.purgedHistories).toString();
    }
}

