/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.access.concepts.UnsupportedRequestException;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ReadOnlyShardDataTreeTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class FrontendReadOnlyTransaction
extends FrontendTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendReadOnlyTransaction.class);
    private final ReadOnlyShardDataTreeTransaction openTransaction;

    private FrontendReadOnlyTransaction(AbstractFrontendHistory history, ReadOnlyShardDataTreeTransaction transaction) {
        super(history, transaction.getIdentifier());
        this.openTransaction = (ReadOnlyShardDataTreeTransaction)Preconditions.checkNotNull((Object)transaction);
    }

    static FrontendReadOnlyTransaction create(AbstractFrontendHistory history, ReadOnlyShardDataTreeTransaction transaction) {
        return new FrontendReadOnlyTransaction(history, transaction);
    }

    @Override
    @Nullable
    TransactionSuccess<?> doHandleRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
        if (request instanceof ExistsTransactionRequest) {
            return this.handleExistsTransaction((ExistsTransactionRequest)request);
        }
        if (request instanceof ReadTransactionRequest) {
            return this.handleReadTransaction((ReadTransactionRequest)request);
        }
        if (request instanceof ModifyTransactionRequest) {
            this.handleModifyTransaction((ModifyTransactionRequest)request, envelope, now);
            return null;
        }
        LOG.warn("Rejecting unsupported request {}", request);
        throw new UnsupportedRequestException(request);
    }

    @Override
    void retire() {
    }

    private void handleModifyTransaction(ModifyTransactionRequest request, RequestEnvelope envelope, long now) {
        Optional optProto = request.getPersistenceProtocol();
        Preconditions.checkArgument((boolean)optProto.isPresent(), (String)"Commit protocol is missing in %s", (Object)request);
        Preconditions.checkArgument((optProto.get() == PersistenceProtocol.ABORT ? 1 : 0) != 0, (String)"Unsupported commit protocol in %s", (Object)request);
        this.openTransaction.abort(() -> this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new ModifyTransactionSuccess((TransactionIdentifier)request.getTarget(), request.getSequence())));
    }

    private ExistsTransactionSuccess handleExistsTransaction(ExistsTransactionRequest request) throws RequestException {
        com.google.common.base.Optional data = com.google.common.base.Optional.fromJavaUtil((Optional)this.openTransaction.getSnapshot().readNode(request.getPath()));
        return this.recordSuccess(request.getSequence(), new ExistsTransactionSuccess(this.openTransaction.getIdentifier(), request.getSequence(), data.isPresent()));
    }

    private ReadTransactionSuccess handleReadTransaction(ReadTransactionRequest request) throws RequestException {
        com.google.common.base.Optional data = com.google.common.base.Optional.fromJavaUtil((Optional)this.openTransaction.getSnapshot().readNode(request.getPath()));
        return this.recordSuccess(request.getSequence(), new ReadTransactionSuccess(this.openTransaction.getIdentifier(), request.getSequence(), data));
    }
}

