/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.LocalThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.LocalTransactionFactory;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedTransactions;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;

final class LocalTransactionFactoryImpl
extends SnapshotBackedWriteTransaction.TransactionReadyPrototype<TransactionIdentifier>
implements LocalTransactionFactory {
    private final ActorSelection leader;
    private final DataTree dataTree;
    private final ActorContext actorContext;

    LocalTransactionFactoryImpl(ActorContext actorContext, ActorSelection leader, DataTree dataTree) {
        this.leader = (ActorSelection)Preconditions.checkNotNull((Object)leader);
        this.dataTree = (DataTree)Preconditions.checkNotNull((Object)dataTree);
        this.actorContext = actorContext;
    }

    DataTree getDataTree() {
        return this.dataTree;
    }

    @Override
    public DOMStoreReadTransaction newReadOnlyTransaction(TransactionIdentifier identifier) {
        return SnapshotBackedTransactions.newReadTransaction((Object)identifier, (boolean)false, (DataTreeSnapshot)this.dataTree.takeSnapshot());
    }

    @Override
    public DOMStoreReadWriteTransaction newReadWriteTransaction(TransactionIdentifier identifier) {
        return SnapshotBackedTransactions.newReadWriteTransaction((Object)identifier, (boolean)false, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    @Override
    public DOMStoreWriteTransaction newWriteOnlyTransaction(TransactionIdentifier identifier) {
        return SnapshotBackedTransactions.newWriteTransaction((Object)identifier, (boolean)false, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    protected void transactionAborted(SnapshotBackedWriteTransaction<TransactionIdentifier> tx) {
    }

    protected DOMStoreThreePhaseCommitCohort transactionReady(SnapshotBackedWriteTransaction<TransactionIdentifier> tx, DataTreeModification tree, Exception readyError) {
        return new LocalThreePhaseCommitCohort(this.actorContext, this.leader, tx, tree, readyError);
    }

    @Override
    public LocalThreePhaseCommitCohort onTransactionReady(@Nonnull DOMStoreWriteTransaction tx, @Nullable Exception operationError) {
        Preconditions.checkArgument((boolean)(tx instanceof SnapshotBackedWriteTransaction));
        if (operationError != null) {
            return new LocalThreePhaseCommitCohort(this.actorContext, this.leader, (SnapshotBackedWriteTransaction<TransactionIdentifier>)((SnapshotBackedWriteTransaction)tx), operationError);
        }
        return (LocalThreePhaseCommitCohort)tx.ready();
    }
}

