/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props;
import com.google.common.base.Optional;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeNotificationPublisherActorProxy;
import org.opendaylight.controller.cluster.datastore.ShardDataChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataChangePublisherActor;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

@NotThreadSafe
class ShardDataChangeListenerPublisherActorProxy
extends AbstractShardDataTreeNotificationPublisherActorProxy
implements ShardDataChangeListenerPublisher {
    ShardDataChangeListenerPublisherActorProxy(ActorContext actorContext, String actorName, String logContext) {
        super(actorContext, actorName, logContext);
    }

    @Override
    public void registerDataChangeListener(YangInstanceIdentifier path, AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener, AsyncDataBroker.DataChangeScope scope, Optional<DataTreeCandidate> initialState, Consumer<ListenerRegistration<AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>>> onRegistration) {
        this.publisherActor().tell((Object)new ShardDataChangePublisherActor.RegisterListener(path, listener, scope, initialState, onRegistration), ActorRef.noSender());
    }

    @Override
    protected Props props() {
        return ShardDataChangePublisherActor.props(this.actorName(), this.logContext());
    }
}

