/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

@VisibleForTesting
public abstract class ShardDataTreeCohort
implements Identifiable<TransactionIdentifier> {
    ShardDataTreeCohort() {
    }

    abstract DataTreeCandidateTip getCandidate();

    abstract DataTreeModification getDataTreeModification();

    @VisibleForTesting
    public abstract void canCommit(FutureCallback<Void> var1);

    @VisibleForTesting
    public abstract void preCommit(FutureCallback<DataTreeCandidate> var1);

    @VisibleForTesting
    public abstract void abort(FutureCallback<Void> var1);

    @VisibleForTesting
    public abstract void commit(FutureCallback<UnsignedLong> var1);

    public abstract boolean isFailed();

    public abstract State getState();

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("id", this.getIdentifier()).add("state", (Object)this.getState());
    }

    public static enum State {
        READY,
        CAN_COMMIT_PENDING,
        CAN_COMMIT_COMPLETE,
        PRE_COMMIT_PENDING,
        PRE_COMMIT_COMPLETE,
        COMMIT_PENDING,
        ABORTED,
        COMMITTED,
        FAILED;

    }
}

