/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.dispatch.OnComplete;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.NoOpDOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.OperationCallback;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

class SingleCommitCohortProxy
extends AbstractThreePhaseCommitCohort<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleCommitCohortProxy.class);
    private final ActorContext actorContext;
    private final Future<Object> cohortFuture;
    private final TransactionIdentifier transactionId;
    private volatile DOMStoreThreePhaseCommitCohort delegateCohort = NoOpDOMStoreThreePhaseCommitCohort.INSTANCE;
    private final OperationCallback.Reference operationCallbackRef;

    SingleCommitCohortProxy(ActorContext actorContext, Future<Object> cohortFuture, TransactionIdentifier transactionId, OperationCallback.Reference operationCallbackRef) {
        this.actorContext = actorContext;
        this.cohortFuture = cohortFuture;
        this.transactionId = (TransactionIdentifier)Preconditions.checkNotNull((Object)transactionId);
        this.operationCallbackRef = operationCallbackRef;
    }

    public ListenableFuture<Boolean> canCommit() {
        LOG.debug("Tx {} canCommit", (Object)this.transactionId);
        final SettableFuture returnFuture = SettableFuture.create();
        this.cohortFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object cohortResponse) {
                if (failure != null) {
                    ((OperationCallback)SingleCommitCohortProxy.this.operationCallbackRef.get()).failure();
                    returnFuture.setException(failure);
                    return;
                }
                ((OperationCallback)SingleCommitCohortProxy.this.operationCallbackRef.get()).success();
                LOG.debug("Tx {} successfully completed direct commit", (Object)SingleCommitCohortProxy.this.transactionId);
                returnFuture.set((Object)Boolean.TRUE);
            }
        }, this.actorContext.getClientDispatcher());
        return returnFuture;
    }

    public ListenableFuture<Void> preCommit() {
        return this.delegateCohort.preCommit();
    }

    public ListenableFuture<Void> abort() {
        return this.delegateCohort.abort();
    }

    public ListenableFuture<Void> commit() {
        return this.delegateCohort.commit();
    }

    @Override
    List<Future<Object>> getCohortFutures() {
        return Arrays.asList(this.cohortFuture);
    }
}

