/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendReadOnlyTransaction;
import org.opendaylight.controller.cluster.datastore.FrontendReadWriteTransaction;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

final class StandaloneFrontendHistory
extends AbstractFrontendHistory {
    private final LocalHistoryIdentifier identifier;
    private final ShardDataTree tree;

    private StandaloneFrontendHistory(String persistenceId, ClientIdentifier clientId, ShardDataTree tree, Map<UnsignedLong, Boolean> closedTransactions, RangeSet<UnsignedLong> purgedTransactions) {
        super(persistenceId, tree, closedTransactions, purgedTransactions);
        this.identifier = new LocalHistoryIdentifier(clientId, 0L);
        this.tree = (ShardDataTree)Preconditions.checkNotNull((Object)tree);
    }

    static StandaloneFrontendHistory create(String persistenceId, ClientIdentifier clientId, ShardDataTree tree) {
        return new StandaloneFrontendHistory(persistenceId, clientId, tree, (Map<UnsignedLong, Boolean>)ImmutableMap.of(), (RangeSet<UnsignedLong>)TreeRangeSet.create());
    }

    static StandaloneFrontendHistory recreate(String persistenceId, ClientIdentifier clientId, ShardDataTree tree, Map<UnsignedLong, Boolean> closedTransactions, RangeSet<UnsignedLong> purgedTransactions) {
        return new StandaloneFrontendHistory(persistenceId, clientId, tree, new HashMap<UnsignedLong, Boolean>(closedTransactions), purgedTransactions);
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    FrontendTransaction createOpenSnapshot(TransactionIdentifier id) throws RequestException {
        return FrontendReadOnlyTransaction.create(this, this.tree.newReadOnlyTransaction(id));
    }

    @Override
    FrontendTransaction createOpenTransaction(TransactionIdentifier id) throws RequestException {
        return FrontendReadWriteTransaction.createOpen(this, this.tree.newReadWriteTransaction(id));
    }

    @Override
    FrontendTransaction createReadyTransaction(TransactionIdentifier id, DataTreeModification mod) throws RequestException {
        return FrontendReadWriteTransaction.createReady(this, id, mod);
    }

    @Override
    ShardDataTreeCohort createFailedCohort(TransactionIdentifier id, DataTreeModification mod, Exception failure) {
        return this.tree.createFailedCohort(id, mod, failure);
    }

    @Override
    ShardDataTreeCohort createReadyCohort(TransactionIdentifier id, DataTreeModification mod) {
        return this.tree.createReadyCohort(id, mod);
    }
}

