/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Mapper;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.ReadyTransactionReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

public class TransactionReadyReplyMapper
extends Mapper<Object, ActorSelection> {
    protected static final Mapper<Throwable, Throwable> SAME_FAILURE_TRANSFORMER = new Mapper<Throwable, Throwable>(){

        public Throwable apply(Throwable failure) {
            return failure;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(TransactionReadyReplyMapper.class);
    private final TransactionIdentifier identifier;
    private final ActorContext actorContext;

    protected TransactionReadyReplyMapper(ActorContext actorContext, TransactionIdentifier identifier) {
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext);
        this.identifier = (TransactionIdentifier)Preconditions.checkNotNull((Object)identifier);
    }

    protected final ActorContext getActorContext() {
        return this.actorContext;
    }

    protected String extractCohortPathFrom(ReadyTransactionReply readyTxReply) {
        return readyTxReply.getCohortPath();
    }

    public final ActorSelection checkedApply(Object serializedReadyReply) {
        LOG.debug("Tx {} readyTransaction", (Object)this.identifier);
        if (ReadyTransactionReply.isSerializedType(serializedReadyReply)) {
            ReadyTransactionReply readyTxReply = ReadyTransactionReply.fromSerializable(serializedReadyReply);
            return this.actorContext.actorSelection(this.extractCohortPathFrom(readyTxReply));
        }
        throw new IllegalArgumentException(String.format("%s: Invalid reply type %s", this.identifier, serializedReadyReply.getClass()));
    }

    static Future<ActorSelection> transform(Future<Object> readyReplyFuture, ActorContext actorContext, TransactionIdentifier identifier) {
        return readyReplyFuture.transform((Function1)new TransactionReadyReplyMapper(actorContext, identifier), SAME_FAILURE_TRANSFORMER, actorContext.getClientDispatcher());
    }
}

