/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.actors;

import akka.actor.ActorRef;
import akka.actor.Props;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActorWithMetering;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshotReply;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

public final class ShardSnapshotActor
extends AbstractUntypedActorWithMetering {
    private static final String ACTOR_NAME_FOR_METERING = "shard-snapshot";

    private ShardSnapshotActor() {
        super(ACTOR_NAME_FOR_METERING);
    }

    protected void handleReceive(Object message) throws Exception {
        if (message instanceof SerializeSnapshot) {
            this.onSerializeSnapshot((SerializeSnapshot)message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void onSerializeSnapshot(SerializeSnapshot request) {
        Optional<OutputStream> installSnapshotStream = request.getInstallSnapshotStream();
        if (installSnapshotStream.isPresent()) {
            try (ObjectOutputStream out = new ObjectOutputStream(installSnapshotStream.get());){
                request.getSnapshot().serialize(out);
            }
            catch (IOException e) {
                this.LOG.error("Error serializing snapshot", (Throwable)e);
            }
        }
        request.getReplyTo().tell((Object)new CaptureSnapshotReply((Snapshot.State)new ShardSnapshotState(request.getSnapshot()), installSnapshotStream), ActorRef.noSender());
    }

    public static void requestSnapshot(ActorRef snapshotActor, ShardDataTreeSnapshot snapshot, Optional<OutputStream> installSnapshotStream, ActorRef replyTo) {
        snapshotActor.tell((Object)new SerializeSnapshot(snapshot, installSnapshotStream, replyTo), ActorRef.noSender());
    }

    public static Props props() {
        return Props.create(ShardSnapshotActor.class, (Object[])new Object[0]);
    }

    private static final class SerializeSnapshot {
        private final ShardDataTreeSnapshot snapshot;
        private final Optional<OutputStream> installSnapshotStream;
        private final ActorRef replyTo;

        SerializeSnapshot(ShardDataTreeSnapshot snapshot, Optional<OutputStream> installSnapshotStream, ActorRef replyTo) {
            this.snapshot = (ShardDataTreeSnapshot)Preconditions.checkNotNull((Object)snapshot);
            this.installSnapshotStream = (Optional)Preconditions.checkNotNull(installSnapshotStream);
            this.replyTo = (ActorRef)Preconditions.checkNotNull((Object)replyTo);
        }

        ShardDataTreeSnapshot getSnapshot() {
            return this.snapshot;
        }

        Optional<OutputStream> getInstallSnapshotStream() {
            return this.installSnapshotStream;
        }

        ActorRef getReplyTo() {
            return this.replyTo;
        }
    }
}

